
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p348151_="https://jakarta.ee/xml/ns/jaxb" xmlns:p707914_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the version of the ZUGFeRD XML file that should be embedded with "xmlFile".&#13;
 *                     Versions from 1.0 to 2.3 are supported.&#13;
 *                     Only the "Comfort" profile is available for version 1.0.&#13;
 *                     Meanwhile, the "Minimum", "Basic WL", "Basic", "EN16931" (Comfort), and "Extended" profiles are&#13;
 *                     supported for version 2.0.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p348151_="https://jakarta.ee/xml/ns/jaxb" xmlns:p707914_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Note:&lt;/b&gt;&#13;
 *                     Since version 2.x, the referenced profile "XRECHNUNG" is additionally available. This profile has&#13;
 *                     been included specifically to include invoices for Germany, based on and under the sole&#13;
 *                     responsibility of KoSIT, Germany's central coordination agency for IT's e-invoice CIUS "XRechnung".&#13;
 *                     It is defined as the Standard for electronic invoices issued to public administrations, and&#13;
 *                     essentially adds specific business rules to EN 16931 in order to comply with national laws and&#13;
 *                     regulations.&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p348151_="https://jakarta.ee/xml/ns/jaxb" xmlns:p707914_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Note:&lt;/b&gt;&#13;
 *                     Since version 2.1.1 ZUGFeRD and Factur-X are technically identical, and both formats use Factur-X as&#13;
 *                     common identification.&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p348151_="https://jakarta.ee/xml/ns/jaxb" xmlns:p707914_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
 *                     List of versions with the corresponding profiles:&#13;
 *                     &lt;ul&gt;&lt;li&gt;v10Comfort&lt;/li&gt;&lt;li&gt;v20Minimum&lt;/li&gt;&lt;li&gt;v20BasicWL&lt;/li&gt;&lt;li&gt;v20Basic&lt;/li&gt;&lt;li&gt;v20EN16931&lt;/li&gt;&lt;li&gt;v20Extended&lt;/li&gt;&lt;li&gt;v21Minimum&lt;/li&gt;&lt;li&gt;v21BasicWL&lt;/li&gt;&lt;li&gt;v21Basic&lt;/li&gt;&lt;li&gt;v21EN16931&lt;/li&gt;&lt;li&gt;v21Extended&lt;/li&gt;&lt;li&gt;v21XRechnung&lt;/li&gt;&lt;li&gt;v22Minimum&lt;/li&gt;&lt;li&gt;v22BasicWL&lt;/li&gt;&lt;li&gt;v22Basic&lt;/li&gt;&lt;li&gt;v22EN16931&lt;/li&gt;&lt;li&gt;v22Extended&lt;/li&gt;&lt;li&gt;v22XRechnung&lt;/li&gt;&lt;li&gt;v23Minimum&lt;/li&gt;&lt;li&gt;v23BasicWL&lt;/li&gt;&lt;li&gt;v23Basic&lt;/li&gt;&lt;li&gt;v23EN16931&lt;/li&gt;&lt;li&gt;v23Extended&lt;/li&gt;&lt;li&gt;v23XRechnung&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ZugferdVersionType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="ZugferdVersionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="v10Comfort"/>
 *     <enumeration value="v20Minimum"/>
 *     <enumeration value="v20BasicWL"/>
 *     <enumeration value="v20Basic"/>
 *     <enumeration value="v20EN16931"/>
 *     <enumeration value="v20Extended"/>
 *     <enumeration value="v21Minimum"/>
 *     <enumeration value="v21BasicWL"/>
 *     <enumeration value="v21Basic"/>
 *     <enumeration value="v21EN16931"/>
 *     <enumeration value="v21Extended"/>
 *     <enumeration value="v21XRechnung"/>
 *     <enumeration value="v22Minimum"/>
 *     <enumeration value="v22BasicWL"/>
 *     <enumeration value="v22Basic"/>
 *     <enumeration value="v22EN16931"/>
 *     <enumeration value="v22Extended"/>
 *     <enumeration value="v22XRechnung"/>
 *     <enumeration value="v23Minimum"/>
 *     <enumeration value="v23BasicWL"/>
 *     <enumeration value="v23Basic"/>
 *     <enumeration value="v23EN16931"/>
 *     <enumeration value="v23Extended"/>
 *     <enumeration value="v23XRechnung"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "ZugferdVersionType")
@XmlEnum
public enum ZugferdVersionType {

    @XmlEnumValue("v10Comfort")
    V_10_COMFORT("v10Comfort"),
    @XmlEnumValue("v20Minimum")
    V_20_MINIMUM("v20Minimum"),
    @XmlEnumValue("v20BasicWL")
    V_20_BASIC_WL("v20BasicWL"),
    @XmlEnumValue("v20Basic")
    V_20_BASIC("v20Basic"),
    @XmlEnumValue("v20EN16931")
    V_20_EN_16931("v20EN16931"),
    @XmlEnumValue("v20Extended")
    V_20_EXTENDED("v20Extended"),
    @XmlEnumValue("v21Minimum")
    V_21_MINIMUM("v21Minimum"),
    @XmlEnumValue("v21BasicWL")
    V_21_BASIC_WL("v21BasicWL"),
    @XmlEnumValue("v21Basic")
    V_21_BASIC("v21Basic"),
    @XmlEnumValue("v21EN16931")
    V_21_EN_16931("v21EN16931"),
    @XmlEnumValue("v21Extended")
    V_21_EXTENDED("v21Extended"),
    @XmlEnumValue("v21XRechnung")
    V_21_X_RECHNUNG("v21XRechnung"),
    @XmlEnumValue("v22Minimum")
    V_22_MINIMUM("v22Minimum"),
    @XmlEnumValue("v22BasicWL")
    V_22_BASIC_WL("v22BasicWL"),
    @XmlEnumValue("v22Basic")
    V_22_BASIC("v22Basic"),
    @XmlEnumValue("v22EN16931")
    V_22_EN_16931("v22EN16931"),
    @XmlEnumValue("v22Extended")
    V_22_EXTENDED("v22Extended"),
    @XmlEnumValue("v22XRechnung")
    V_22_X_RECHNUNG("v22XRechnung"),
    @XmlEnumValue("v23Minimum")
    V_23_MINIMUM("v23Minimum"),
    @XmlEnumValue("v23BasicWL")
    V_23_BASIC_WL("v23BasicWL"),
    @XmlEnumValue("v23Basic")
    V_23_BASIC("v23Basic"),
    @XmlEnumValue("v23EN16931")
    V_23_EN_16931("v23EN16931"),
    @XmlEnumValue("v23Extended")
    V_23_EXTENDED("v23Extended"),
    @XmlEnumValue("v23XRechnung")
    V_23_X_RECHNUNG("v23XRechnung");
    private final String value;

    ZugferdVersionType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static ZugferdVersionType fromValue(String v) {
        for (ZugferdVersionType c: ZugferdVersionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
