
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import net.webpdf.wsclient.schema.FileDataType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p672351_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p68930_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the content that will be used as a footer. The content is passed in BASE64 encoded and contains&#13;
 *                     HTML and (embedded) CSS code to position and format the footer.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p672351_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p68930_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The footer can contain the variables &lt;code&gt;${html.pageNumber}&lt;/code&gt; (page number), &lt;code&gt;${html.totalPages}&lt;/code&gt; (total number of pages)&#13;
 *                     and &lt;code&gt;${html.title}&lt;/code&gt; (HTML head meta tag &lt;code&gt;&amp;lt;title&amp;gt;&lt;/code&gt;).&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p672351_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p68930_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;The footer is not used for all file format conversions. The footer is not supported for file formats that&#13;
 *                     already contain their own footer definition, such as Office formats. The footer defined here works only for HTML-based&#13;
 *                     formats such as HTML files, emails, or template-based conversions (e.g. text formats).&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p672351_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p68930_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Example:&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;pre xmlns:p672351_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p68930_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema" class="language-html"&gt;&#13;
 *                     &#13;
 * &amp;lt;p&amp;gt;&#13;
 *   &amp;lt;span style="font-size: 12px"&amp;gt;Page ${html.pageNumber} of ${html.totalPages} pages&amp;lt;/span&amp;gt;&#13;
 * &amp;lt;/p&amp;gt;&#13;
 * &#13;
 *                 &lt;/pre&gt;
 * </pre>
 * 
 * <p>Java class for UrlConverterFooterType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="UrlConverterFooterType">
 *   <simpleContent>
 *     <extension base="<http://www.w3.org/2001/XMLSchema>base64Binary">
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}FileDataGroup"/>
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "UrlConverterFooterType", propOrder = {
    "value"
})
public class UrlConverterFooterType
    implements FileDataType<byte[]>
{

    @XmlValue
    protected byte[] value;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the data source for the hereby expressed resource.&#13;
     *                         Possible values are:&#13;
     *                         &lt;ul&gt;&lt;li&gt;value = The element's value shall contain the BASE64 encoded data.&lt;/li&gt;&lt;li&gt;uri = The data shall be located at the given uri.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "source")
    protected FileDataSourceType source;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The uri the data shall be located at. (This shall only have effect, if the "source" is "uri".)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "uri")
    @XmlSchemaType(name = "anyURI")
    protected String uri;

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setValue(byte[] value) {
        this.value = value;
    }

    public boolean isSetValue() {
        return (this.value!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the data source for the hereby expressed resource.&#13;
     *                         Possible values are:&#13;
     *                         &lt;ul&gt;&lt;li&gt;value = The element's value shall contain the BASE64 encoded data.&lt;/li&gt;&lt;li&gt;uri = The data shall be located at the given uri.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FileDataSourceType }
     *     
     */
    public FileDataSourceType getSource() {
        if (source == null) {
            return FileDataSourceType.VALUE;
        } else {
            return source;
        }
    }

    /**
     * Sets the value of the source property.
     * 
     * @param value
     *     allowed object is
     *     {@link FileDataSourceType }
     *     
     * @see #getSource()
     */
    public void setSource(FileDataSourceType value) {
        this.source = value;
    }

    public boolean isSetSource() {
        return (this.source!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The uri the data shall be located at. (This shall only have effect, if the "source" is "uri".)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUri() {
        if (uri == null) {
            return "";
        } else {
            return uri;
        }
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUri()
     */
    public void setUri(String value) {
        this.uri = value;
    }

    public boolean isSetUri() {
        return (this.uri!= null);
    }

}
