
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The direction of the transition animation (provided that it can be applied to the animation).&#13;
 *                     &lt;ul&gt;&lt;li&gt;leftToRight = From left to right&lt;/li&gt;&lt;li&gt;bottomToTop = From bottom to top&lt;/li&gt;&lt;li&gt;rightToLeft = From right to left&lt;/li&gt;&lt;li&gt;topToBottom = From top to bottom&lt;/li&gt;&lt;li&gt;topLeftToBottomRight = From top left to bottom right&lt;/li&gt;&lt;li&gt;none = Use the default value for the animation&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TransitionDirection</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="TransitionDirection">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="leftToRight"/>
 *     <enumeration value="bottomToTop"/>
 *     <enumeration value="rightToLeft"/>
 *     <enumeration value="topToBottom"/>
 *     <enumeration value="topLeftToBottomRight"/>
 *     <enumeration value="none"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TransitionDirection")
@XmlEnum
public enum TransitionDirection {

    @XmlEnumValue("leftToRight")
    LEFT_TO_RIGHT("leftToRight"),
    @XmlEnumValue("bottomToTop")
    BOTTOM_TO_TOP("bottomToTop"),
    @XmlEnumValue("rightToLeft")
    RIGHT_TO_LEFT("rightToLeft"),
    @XmlEnumValue("topToBottom")
    TOP_TO_BOTTOM("topToBottom"),
    @XmlEnumValue("topLeftToBottomRight")
    TOP_LEFT_TO_BOTTOM_RIGHT("topLeftToBottomRight"),
    @XmlEnumValue("none")
    NONE("none");
    private final String value;

    TransitionDirection(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static TransitionDirection fromValue(String v) {
        for (TransitionDirection c: TransitionDirection.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
