
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When activated, the goToThread action jumps to a specific thread defined in the document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ThreadActionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ThreadActionType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ActionEventType">
 *       <attribute name="beadIndex">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="page" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="threadTitle" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="threadIndex">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ThreadActionType")
public class ThreadActionType
    extends ActionEventType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The index of the thread section to which the jump should be. This value is optional and does not need to be specified.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "beadIndex")
    protected Integer beadIndex;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page number of the page where the thread is found.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The title of the thread to which the jump should be. This value is an alternative to "threadIndex" and does not have to be set if the latter has been specified.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "threadTitle")
    protected String threadTitle;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The index of the thread in the document's thread directory to which the jump should be. This value is an alternative to "threadTitle" and does not have to be set if the latter has been specified.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "threadIndex")
    protected Integer threadIndex;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The index of the thread section to which the jump should be. This value is optional and does not need to be specified.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getBeadIndex() {
        return beadIndex;
    }

    /**
     * Sets the value of the beadIndex property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getBeadIndex()
     */
    public void setBeadIndex(int value) {
        this.beadIndex = value;
    }

    public boolean isSetBeadIndex() {
        return (this.beadIndex!= null);
    }

    public void unsetBeadIndex() {
        this.beadIndex = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page number of the page where the thread is found.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  1;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The title of the thread to which the jump should be. This value is an alternative to "threadIndex" and does not have to be set if the latter has been specified.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getThreadTitle() {
        return threadTitle;
    }

    /**
     * Sets the value of the threadTitle property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getThreadTitle()
     */
    public void setThreadTitle(String value) {
        this.threadTitle = value;
    }

    public boolean isSetThreadTitle() {
        return (this.threadTitle!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The index of the thread in the document's thread directory to which the jump should be. This value is an alternative to "threadTitle" and does not have to be set if the latter has been specified.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getThreadIndex() {
        return threadIndex;
    }

    /**
     * Sets the value of the threadIndex property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getThreadIndex()
     */
    public void setThreadIndex(int value) {
        this.threadIndex = value;
    }

    public boolean isSetThreadIndex() {
        return (this.threadIndex!= null);
    }

    public void unsetThreadIndex() {
        this.threadIndex = null;
    }

}
