
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The &lt;code&gt;signature&lt;/code&gt; element allows to set settings for automatic signature handling and verification. All web services prioritize checking whether their execution is valid for a given signed document - according to these settings - or would risk invalidation of the existing signatures. (This is also defining profiles, that would allow signature invalidation).&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SignatureSettingsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SignatureSettingsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="signatureEditProfile" type="{http://schema.webpdf.de/1.0/operation}SignatureEditProfileType" default="adobeRestrictions" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SignatureSettingsType")
public class SignatureSettingsType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the profile whose rules web services have to check before they can come to execution. These profiles define a set of rules concerning the validity of signatures. A web service whose execution for a given signed document would violate the rule set selected here should instead abort with an appropriate error code.&#13;
     *                         &lt;ul&gt;&lt;li&gt;adobeRestrictions = Only those changes are allowed that are enabled by the included signatures. This follows the specifications given by Adobe.&lt;/li&gt;&lt;li&gt;generalEditRestrictions = All changes to signed documents are prohibited, even those that might be allowed according to the included signatures.&lt;/li&gt;&lt;li&gt;noEditRestrictions = Editing of signed documents is not restricted and all changes are allowed. (By doing this, you accept the possible invalidation of included signatures.)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         You can find further explanations of these profiles in the chapter "Signature Validation".&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "signatureEditProfile")
    protected SignatureEditProfileType signatureEditProfile;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the profile whose rules web services have to check before they can come to execution. These profiles define a set of rules concerning the validity of signatures. A web service whose execution for a given signed document would violate the rule set selected here should instead abort with an appropriate error code.&#13;
     *                         &lt;ul&gt;&lt;li&gt;adobeRestrictions = Only those changes are allowed that are enabled by the included signatures. This follows the specifications given by Adobe.&lt;/li&gt;&lt;li&gt;generalEditRestrictions = All changes to signed documents are prohibited, even those that might be allowed according to the included signatures.&lt;/li&gt;&lt;li&gt;noEditRestrictions = Editing of signed documents is not restricted and all changes are allowed. (By doing this, you accept the possible invalidation of included signatures.)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         You can find further explanations of these profiles in the chapter "Signature Validation".&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SignatureEditProfileType }
     *     
     */
    public SignatureEditProfileType getSignatureEditProfile() {
        if (signatureEditProfile == null) {
            return SignatureEditProfileType.ADOBE_RESTRICTIONS;
        } else {
            return signatureEditProfile;
        }
    }

    /**
     * Sets the value of the signatureEditProfile property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureEditProfileType }
     *     
     * @see #getSignatureEditProfile()
     */
    public void setSignatureEditProfile(SignatureEditProfileType value) {
        this.signatureEditProfile = value;
    }

    public boolean isSetSignatureEditProfile() {
        return (this.signatureEditProfile!= null);
    }

}
