
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The scale operation element can be used to scale pages in the document. In the following passage, terms such as the "media box", the "bleed box" and similar are used. This assumes, therefore, that you are familiar with the contexts described in the chapter "Display options".&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ScaleType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ScaleType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <choice>
 *         <element name="scalePages" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice>
 *                   <element name="dimensions" type="{http://schema.webpdf.de/1.0/operation}PaddedRectangleType" minOccurs="0"/>
 *                 </choice>
 *                 <attGroup ref="{http://schema.webpdf.de/1.0/operation}AlignmentGroup"/>
 *                 <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                 <attribute name="scaleBoxes" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *                 <attribute name="preserveAspectRatio" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </choice>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ScaleType", propOrder = {
    "scalePages"
})
public class ScaleType
    extends BaseToolboxType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define page scaling operations.&lt;/p&gt;
     * </pre>
     * 
     */
    protected ScaleType.ScalePages scalePages;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define page scaling operations.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ScaleType.ScalePages }
     *     
     */
    public ScaleType.ScalePages getScalePages() {
        return scalePages;
    }

    /**
     * Sets the value of the scalePages property.
     * 
     * @param value
     *     allowed object is
     *     {@link ScaleType.ScalePages }
     *     
     * @see #getScalePages()
     */
    public void setScalePages(ScaleType.ScalePages value) {
        this.scalePages = value;
    }

    public boolean isSetScalePages() {
        return (this.scalePages!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice>
     *         <element name="dimensions" type="{http://schema.webpdf.de/1.0/operation}PaddedRectangleType" minOccurs="0"/>
     *       </choice>
     *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}AlignmentGroup"/>
     *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *       <attribute name="scaleBoxes" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
     *       <attribute name="preserveAspectRatio" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "dimensions"
    })
    public static class ScalePages {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Care should be taken when applying these parameter: When a padding is set, the page contents will be moved from their original position, which could also mean moving elements into the visible area that were previously hidden by the CropBox.&lt;/p&gt;
         * </pre>
         * 
         */
        protected PaddedRectangleType dimensions;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies which page(s) should be scaled. The page number can be either a single page, a range of pages or a list (separated by commas) (e.g. "1.5-6.9"). The specification of all pages is done with "*".&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "pages")
        protected String pages;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies whether the scaling of the page should also affect the boxes (Mediabox, Cropbox, etc.) of a page. If this is not the case (false), the actual page dimensions, crop boxes, etc. remain as they were originally and only page contents are scaled.&#13;
         *                                             The content can become much smaller or larger than the containing page in this way, which can lead to either large blank areas or overflow of the page content.&#13;
         *                                         &lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "scaleBoxes")
        protected Boolean scaleBoxes;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies whether the ratio of the page dimensions to each other should be maintained when scaling the page. This may result in deviations from the given target height or width (depending on requirements).&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "preserveAspectRatio")
        protected Boolean preserveAspectRatio;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If margins are created when the page is scaled or if the page content must be positioned relative to a context (for example, the crop box), this value specifies how margins are to be split and how overall page content is to be positioned on the page.&#13;
         *                         &lt;ul&gt;&lt;li&gt;left = Contents are to be arranged left-justified.&lt;/li&gt;&lt;li&gt;center = Content should be centered.&lt;/li&gt;&lt;li&gt;right = Contents should be arranged right-justified.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "horizontalAlignment")
        protected String horizontalAlignment;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If margins are created when the page is scaled or if the page content must be positioned relative to a context (for example, the crop box), this value specifies how margins are to be split and how overall page content is to be positioned on the page.&#13;
         *                         &lt;ul&gt;&lt;li&gt;top = Content should be positioned at the top of the page.&lt;/li&gt;&lt;li&gt;center = Content should be centered.&lt;/li&gt;&lt;li&gt;bottom = content should be positioned at the bottom.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "verticalAlignment")
        protected String verticalAlignment;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Care should be taken when applying these parameter: When a padding is set, the page contents will be moved from their original position, which could also mean moving elements into the visible area that were previously hidden by the CropBox.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link PaddedRectangleType }
         *     
         */
        public PaddedRectangleType getDimensions() {
            return dimensions;
        }

        /**
         * Sets the value of the dimensions property.
         * 
         * @param value
         *     allowed object is
         *     {@link PaddedRectangleType }
         *     
         * @see #getDimensions()
         */
        public void setDimensions(PaddedRectangleType value) {
            this.dimensions = value;
        }

        public boolean isSetDimensions() {
            return (this.dimensions!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies which page(s) should be scaled. The page number can be either a single page, a range of pages or a list (separated by commas) (e.g. "1.5-6.9"). The specification of all pages is done with "*".&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getPages() {
            if (pages == null) {
                return "";
            } else {
                return pages;
            }
        }

        /**
         * Sets the value of the pages property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getPages()
         */
        public void setPages(String value) {
            this.pages = value;
        }

        public boolean isSetPages() {
            return (this.pages!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies whether the scaling of the page should also affect the boxes (Mediabox, Cropbox, etc.) of a page. If this is not the case (false), the actual page dimensions, crop boxes, etc. remain as they were originally and only page contents are scaled.&#13;
         *                                             The content can become much smaller or larger than the containing page in this way, which can lead to either large blank areas or overflow of the page content.&#13;
         *                                         &lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isScaleBoxes() {
            if (scaleBoxes == null) {
                return true;
            } else {
                return scaleBoxes;
            }
        }

        /**
         * Sets the value of the scaleBoxes property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         * @see #isScaleBoxes()
         */
        public void setScaleBoxes(boolean value) {
            this.scaleBoxes = value;
        }

        public boolean isSetScaleBoxes() {
            return (this.scaleBoxes!= null);
        }

        public void unsetScaleBoxes() {
            this.scaleBoxes = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies whether the ratio of the page dimensions to each other should be maintained when scaling the page. This may result in deviations from the given target height or width (depending on requirements).&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isPreserveAspectRatio() {
            if (preserveAspectRatio == null) {
                return true;
            } else {
                return preserveAspectRatio;
            }
        }

        /**
         * Sets the value of the preserveAspectRatio property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         * @see #isPreserveAspectRatio()
         */
        public void setPreserveAspectRatio(boolean value) {
            this.preserveAspectRatio = value;
        }

        public boolean isSetPreserveAspectRatio() {
            return (this.preserveAspectRatio!= null);
        }

        public void unsetPreserveAspectRatio() {
            this.preserveAspectRatio = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If margins are created when the page is scaled or if the page content must be positioned relative to a context (for example, the crop box), this value specifies how margins are to be split and how overall page content is to be positioned on the page.&#13;
         *                         &lt;ul&gt;&lt;li&gt;left = Contents are to be arranged left-justified.&lt;/li&gt;&lt;li&gt;center = Content should be centered.&lt;/li&gt;&lt;li&gt;right = Contents should be arranged right-justified.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getHorizontalAlignment() {
            if (horizontalAlignment == null) {
                return "left";
            } else {
                return horizontalAlignment;
            }
        }

        /**
         * Sets the value of the horizontalAlignment property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getHorizontalAlignment()
         */
        public void setHorizontalAlignment(String value) {
            this.horizontalAlignment = value;
        }

        public boolean isSetHorizontalAlignment() {
            return (this.horizontalAlignment!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If margins are created when the page is scaled or if the page content must be positioned relative to a context (for example, the crop box), this value specifies how margins are to be split and how overall page content is to be positioned on the page.&#13;
         *                         &lt;ul&gt;&lt;li&gt;top = Content should be positioned at the top of the page.&lt;/li&gt;&lt;li&gt;center = Content should be centered.&lt;/li&gt;&lt;li&gt;bottom = content should be positioned at the bottom.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getVerticalAlignment() {
            if (verticalAlignment == null) {
                return "top";
            } else {
                return verticalAlignment;
            }
        }

        /**
         * Sets the value of the verticalAlignment property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getVerticalAlignment()
         */
        public void setVerticalAlignment(String value) {
            this.verticalAlignment = value;
        }

        public boolean isSetVerticalAlignment() {
            return (this.verticalAlignment!= null);
        }

    }

}
