
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An annotation that either uses an custom image or text as a stamp, or that adds a prepared "named" stamp to the page.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for RubberStampAnnotationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="RubberStampAnnotationType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseAnnotationType">
 *       <all>
 *         <element name="position" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice minOccurs="0">
 *                   <element name="rectangle" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="normalAppearance" type="{http://schema.webpdf.de/1.0/operation}AppearanceSourceType" minOccurs="0"/>
 *       </all>
 *       <attribute name="icon" type="{http://schema.webpdf.de/1.0/operation}RubberStampIconType" default="draft" />
 *       <attribute name="appearanceGeneration" type="{http://schema.webpdf.de/1.0/operation}AppearanceGenerationType" default="nonStandard" />
 *       <attribute name="customIconName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RubberStampAnnotationType", propOrder = {
    "position",
    "normalAppearance"
})
public class RubberStampAnnotationType
    extends BaseAnnotationType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the bounds within which the shape shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     */
    protected RubberStampAnnotationType.Position position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the data source for the visible appearance of a customized rubberstamp.&#13;
     * &#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                     If this element is present, this shall always take precedence for the appearance generation.&#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     */
    protected AppearanceSourceType normalAppearance;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The known "named" icon types for rubberstamp annotations:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;approved = A stamp that marks the stamped context as approved.&lt;/li&gt;&lt;li&gt;experimental = A stamp that marks the stamped content to be an experimental state.&lt;/li&gt;&lt;li&gt;notApproved = A stamp that disapproves the stamped context.&lt;/li&gt;&lt;li&gt;asIs = A stamp that marks the content as is.&lt;/li&gt;&lt;li&gt;expired = A stamp that marks the contained information as no longer valid.&lt;/li&gt;&lt;li&gt;notForPublicRelease = A stamp that marks something as information for internal use only.&lt;/li&gt;&lt;li&gt;confidential = A stamp marking the page as confidential.&lt;/li&gt;&lt;li&gt;final = A stamp that indicates, that the current state of the document is final.&lt;/li&gt;&lt;li&gt;sold = A stamp that indicates the marked contents to be sold and no longer available.&lt;/li&gt;&lt;li&gt;departmental = A stamp that forbids information to be shared to recipient outside of a given department.&lt;/li&gt;&lt;li&gt;forComment = Marks the stamped context as a comment.&lt;/li&gt;&lt;li&gt;topSecret = Marks the stamped content not to be shared publicly.&lt;/li&gt;&lt;li&gt;draft = A stamp marking the content to be a draft and therefore a work in progress.&lt;/li&gt;&lt;li&gt;forPublicRelease = Marks the content for public sharing.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "icon")
    protected RubberStampIconType icon;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Determines for which named annotations appearance streams shall be generated.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 Per definition some named annotations are defined as standard names and PDF readers shall provide the means to draw those. For rubberstamp annotations: approved, experimental, notApproved, asIs, expired, notForPublicRelease, confidential, final, sold, departmental, forComment, topSecret, draft and forPublicRelease are standard names.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;ul&gt;&lt;li&gt;always = An appearance stream shall be prepared for all created named annotations.&lt;/li&gt;&lt;li&gt;never = Don't provide appearance streams and rely on PDF readers to dynamically generate a proper representation of named annotations.&lt;/li&gt;&lt;li&gt;nonStandard = Only provide appearance streams for non standard annotations.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "appearanceGeneration")
    protected AppearanceGenerationType appearanceGeneration;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets a custom icon name for this annotation.&#13;
     * &#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 This name shall always take precedence over possibly set standard names. (icon)&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "customIconName")
    protected String customIconName;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the bounds within which the shape shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RubberStampAnnotationType.Position }
     *     
     */
    public RubberStampAnnotationType.Position getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link RubberStampAnnotationType.Position }
     *     
     * @see #getPosition()
     */
    public void setPosition(RubberStampAnnotationType.Position value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the data source for the visible appearance of a customized rubberstamp.&#13;
     * &#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                     If this element is present, this shall always take precedence for the appearance generation.&#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link AppearanceSourceType }
     *     
     */
    public AppearanceSourceType getNormalAppearance() {
        return normalAppearance;
    }

    /**
     * Sets the value of the normalAppearance property.
     * 
     * @param value
     *     allowed object is
     *     {@link AppearanceSourceType }
     *     
     * @see #getNormalAppearance()
     */
    public void setNormalAppearance(AppearanceSourceType value) {
        this.normalAppearance = value;
    }

    public boolean isSetNormalAppearance() {
        return (this.normalAppearance!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The known "named" icon types for rubberstamp annotations:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;approved = A stamp that marks the stamped context as approved.&lt;/li&gt;&lt;li&gt;experimental = A stamp that marks the stamped content to be an experimental state.&lt;/li&gt;&lt;li&gt;notApproved = A stamp that disapproves the stamped context.&lt;/li&gt;&lt;li&gt;asIs = A stamp that marks the content as is.&lt;/li&gt;&lt;li&gt;expired = A stamp that marks the contained information as no longer valid.&lt;/li&gt;&lt;li&gt;notForPublicRelease = A stamp that marks something as information for internal use only.&lt;/li&gt;&lt;li&gt;confidential = A stamp marking the page as confidential.&lt;/li&gt;&lt;li&gt;final = A stamp that indicates, that the current state of the document is final.&lt;/li&gt;&lt;li&gt;sold = A stamp that indicates the marked contents to be sold and no longer available.&lt;/li&gt;&lt;li&gt;departmental = A stamp that forbids information to be shared to recipient outside of a given department.&lt;/li&gt;&lt;li&gt;forComment = Marks the stamped context as a comment.&lt;/li&gt;&lt;li&gt;topSecret = Marks the stamped content not to be shared publicly.&lt;/li&gt;&lt;li&gt;draft = A stamp marking the content to be a draft and therefore a work in progress.&lt;/li&gt;&lt;li&gt;forPublicRelease = Marks the content for public sharing.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RubberStampIconType }
     *     
     */
    public RubberStampIconType getIcon() {
        if (icon == null) {
            return RubberStampIconType.DRAFT;
        } else {
            return icon;
        }
    }

    /**
     * Sets the value of the icon property.
     * 
     * @param value
     *     allowed object is
     *     {@link RubberStampIconType }
     *     
     * @see #getIcon()
     */
    public void setIcon(RubberStampIconType value) {
        this.icon = value;
    }

    public boolean isSetIcon() {
        return (this.icon!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Determines for which named annotations appearance streams shall be generated.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 Per definition some named annotations are defined as standard names and PDF readers shall provide the means to draw those. For rubberstamp annotations: approved, experimental, notApproved, asIs, expired, notForPublicRelease, confidential, final, sold, departmental, forComment, topSecret, draft and forPublicRelease are standard names.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;ul&gt;&lt;li&gt;always = An appearance stream shall be prepared for all created named annotations.&lt;/li&gt;&lt;li&gt;never = Don't provide appearance streams and rely on PDF readers to dynamically generate a proper representation of named annotations.&lt;/li&gt;&lt;li&gt;nonStandard = Only provide appearance streams for non standard annotations.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link AppearanceGenerationType }
     *     
     */
    public AppearanceGenerationType getAppearanceGeneration() {
        if (appearanceGeneration == null) {
            return AppearanceGenerationType.NON_STANDARD;
        } else {
            return appearanceGeneration;
        }
    }

    /**
     * Sets the value of the appearanceGeneration property.
     * 
     * @param value
     *     allowed object is
     *     {@link AppearanceGenerationType }
     *     
     * @see #getAppearanceGeneration()
     */
    public void setAppearanceGeneration(AppearanceGenerationType value) {
        this.appearanceGeneration = value;
    }

    public boolean isSetAppearanceGeneration() {
        return (this.appearanceGeneration!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets a custom icon name for this annotation.&#13;
     * &#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 This name shall always take precedence over possibly set standard names. (icon)&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCustomIconName() {
        if (customIconName == null) {
            return "";
        } else {
            return customIconName;
        }
    }

    /**
     * Sets the value of the customIconName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCustomIconName()
     */
    public void setCustomIconName(String value) {
        this.customIconName = value;
    }

    public boolean isSetCustomIconName() {
        return (this.customIconName!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice minOccurs="0">
     *         <element name="rectangle" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "rectangle"
    })
    public static class Position {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Select an unrotated rectangular position.&lt;/p&gt;
         * </pre>
         * 
         */
        protected RectangleType rectangle;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Select an unrotated rectangular position.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link RectangleType }
         *     
         */
        public RectangleType getRectangle() {
            return rectangle;
        }

        /**
         * Sets the value of the rectangle property.
         * 
         * @param value
         *     allowed object is
         *     {@link RectangleType }
         *     
         * @see #getRectangle()
         */
        public void setRectangle(RectangleType value) {
            this.rectangle = value;
        }

        public boolean isSetRectangle() {
            return (this.rectangle!= null);
        }

    }

}
