
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p129567_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p842874_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies whether certain contents should be treated differently than others during encryption.&#13;
 *                     &lt;ul&gt;&lt;li&gt;encryptEverything = All contents of the document are encrypted without distinction (if provided by the standard).&lt;/li&gt;&lt;li&gt;exposeMetadata = The document's metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PdfContentEncryptionType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="PdfContentEncryptionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="encryptEverything"/>
 *     <enumeration value="exposeMetadata"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PdfContentEncryptionType")
@XmlEnum
public enum PdfContentEncryptionType {

    @XmlEnumValue("encryptEverything")
    ENCRYPT_EVERYTHING("encryptEverything"),
    @XmlEnumValue("exposeMetadata")
    EXPOSE_METADATA("exposeMetadata");
    private final String value;

    PdfContentEncryptionType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PdfContentEncryptionType fromValue(String v) {
        for (PdfContentEncryptionType c: PdfContentEncryptionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
