
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the page layout when the PDF document is opened.&#13;
 *                     &lt;ul&gt;&lt;li&gt;singlePage = Individual pages&lt;/li&gt;&lt;li&gt;singlePageContinous = Continuous individual pages&lt;/li&gt;&lt;li&gt;twoPages = double pages starting with odd pages&lt;/li&gt;&lt;li&gt;twoPagesRight = double pages starting with even pages&lt;/li&gt;&lt;li&gt;twoPagesContinous = continuous double pages starting with odd pages&lt;/li&gt;&lt;li&gt;twoPagesContinousRight = continuous double pages starting with even pages&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PageLayoutType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="PageLayoutType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="singlePage"/>
 *     <enumeration value="singlePageContinous"/>
 *     <enumeration value="twoPages"/>
 *     <enumeration value="twoPagesRight"/>
 *     <enumeration value="twoPagesContinous"/>
 *     <enumeration value="twoPagesContinousRight"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PageLayoutType")
@XmlEnum
public enum PageLayoutType {

    @XmlEnumValue("singlePage")
    SINGLE_PAGE("singlePage"),
    @XmlEnumValue("singlePageContinous")
    SINGLE_PAGE_CONTINOUS("singlePageContinous"),
    @XmlEnumValue("twoPages")
    TWO_PAGES("twoPages"),
    @XmlEnumValue("twoPagesRight")
    TWO_PAGES_RIGHT("twoPagesRight"),
    @XmlEnumValue("twoPagesContinous")
    TWO_PAGES_CONTINOUS("twoPagesContinous"),
    @XmlEnumValue("twoPagesContinousRight")
    TWO_PAGES_CONTINOUS_RIGHT("twoPagesContinousRight");
    private final String value;

    PageLayoutType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PageLayoutType fromValue(String v) {
        for (PageLayoutType c: PageLayoutType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
