
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p146669_="https://jakarta.ee/xml/ns/jaxb" xmlns:p388438_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Different output formats can be created during character recognition. Generally, the document is generated as a PDF document, but the output can also be as an ASCII document or an XML document if desired (HOCR).&#13;
 *                     &lt;ul&gt;&lt;li&gt;text = Text&lt;/li&gt;&lt;li&gt;hocr = XML (hOCR)&lt;/li&gt;&lt;li&gt;pdf = PDF&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for OcrOutputType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="OcrOutputType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="text"/>
 *     <enumeration value="hocr"/>
 *     <enumeration value="pdf"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "OcrOutputType")
@XmlEnum
public enum OcrOutputType {

    @XmlEnumValue("text")
    TEXT("text"),
    @XmlEnumValue("hocr")
    HOCR("hocr"),
    @XmlEnumValue("pdf")
    PDF("pdf");
    private final String value;

    OcrOutputType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static OcrOutputType fromValue(String v) {
        for (OcrOutputType c: OcrOutputType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
