
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p146669_="https://jakarta.ee/xml/ns/jaxb" xmlns:p388438_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the language for the output document (PDF/image). The language must be defined for the character recognition operation (OCR) so that the "special characters" of the respective language (e.g. "üäö" in German) can be recognized better. At present, the following languages are supported:&#13;
 *                     &lt;ul&gt;&lt;li&gt;eng = English&lt;/li&gt;&lt;li&gt;fra = French&lt;/li&gt;&lt;li&gt;spa = Spanish&lt;/li&gt;&lt;li&gt;deu = German&lt;/li&gt;&lt;li&gt;ita = Italian&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for OcrLanguageType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="OcrLanguageType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="eng"/>
 *     <enumeration value="deu"/>
 *     <enumeration value="fra"/>
 *     <enumeration value="ita"/>
 *     <enumeration value="spa"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "OcrLanguageType")
@XmlEnum
public enum OcrLanguageType {

    @XmlEnumValue("eng")
    ENG("eng"),
    @XmlEnumValue("deu")
    DEU("deu"),
    @XmlEnumValue("fra")
    FRA("fra"),
    @XmlEnumValue("ita")
    ITA("ita"),
    @XmlEnumValue("spa")
    SPA("spa");
    private final String value;

    OcrLanguageType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static OcrLanguageType fromValue(String v) {
        for (OcrLanguageType c: OcrLanguageType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
