
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows the private key for decrypting an asymmetrically encrypted document to be handed over and the associated rights holder (recipient) to be selected by means of the certificate assigned to him.&#13;
 *                     The document can only be decrypted if both are present and the private key and certificate both match and are intended for decrypting the document.&#13;
 * &#13;
 *                     When encrypting the document, it is possible to define multiple rights holders, but when decrypting the document as configured here, only a single one of these rights holders can be selected for which the decryption is to be performed.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for KeyPairType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="KeyPairType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="privateKey" type="{http://schema.webpdf.de/1.0/operation}PrivateKeyFileDataType"/>
 *         <element name="certificate" type="{http://schema.webpdf.de/1.0/operation}CertificateFileDataType"/>
 *       </all>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "KeyPairType", propOrder = {

})
public class KeyPairType {

    @XmlElement(required = true, defaultValue = "")
    protected PrivateKeyFileDataType privateKey;
    @XmlElement(required = true, defaultValue = "")
    protected CertificateFileDataType certificate;

    /**
     * Gets the value of the privateKey property.
     * 
     * @return
     *     possible object is
     *     {@link PrivateKeyFileDataType }
     *     
     */
    public PrivateKeyFileDataType getPrivateKey() {
        return privateKey;
    }

    /**
     * Sets the value of the privateKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrivateKeyFileDataType }
     *     
     */
    public void setPrivateKey(PrivateKeyFileDataType value) {
        this.privateKey = value;
    }

    public boolean isSetPrivateKey() {
        return (this.privateKey!= null);
    }

    /**
     * Gets the value of the certificate property.
     * 
     * @return
     *     possible object is
     *     {@link CertificateFileDataType }
     *     
     */
    public CertificateFileDataType getCertificate() {
        return certificate;
    }

    /**
     * Sets the value of the certificate property.
     * 
     * @param value
     *     allowed object is
     *     {@link CertificateFileDataType }
     *     
     */
    public void setCertificate(CertificateFileDataType value) {
        this.certificate = value;
    }

    public boolean isSetCertificate() {
        return (this.certificate!= null);
    }

}
