
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A font definition for textual annotation types.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for FreeTextFontType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="FreeTextFontType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="bold" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="italic" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="size" default="24">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *             <maxInclusive value="1296"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="color" type="{http://schema.webpdf.de/1.0/operation}RgbColorType" default="#A0A0A0" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FreeTextFontType")
public class FreeTextFontType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the name of the font that should be used for the text output.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "name")
    protected String name;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to increase the text output's weight.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "bold")
    protected Boolean bold;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the italic font posture for the text output.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "italic")
    protected Boolean italic;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the text size for the text output.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "size")
    protected Integer size;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the font color. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "color")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String color;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the name of the font that should be used for the text output.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        if (name == null) {
            return "";
        } else {
            return name;
        }
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    public void setName(String value) {
        this.name = value;
    }

    public boolean isSetName() {
        return (this.name!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to increase the text output's weight.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isBold() {
        if (bold == null) {
            return false;
        } else {
            return bold;
        }
    }

    /**
     * Sets the value of the bold property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isBold()
     */
    public void setBold(boolean value) {
        this.bold = value;
    }

    public boolean isSetBold() {
        return (this.bold!= null);
    }

    public void unsetBold() {
        this.bold = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the italic font posture for the text output.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isItalic() {
        if (italic == null) {
            return false;
        } else {
            return italic;
        }
    }

    /**
     * Sets the value of the italic property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isItalic()
     */
    public void setItalic(boolean value) {
        this.italic = value;
    }

    public boolean isSetItalic() {
        return (this.italic!= null);
    }

    public void unsetItalic() {
        this.italic = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the text size for the text output.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getSize() {
        if (size == null) {
            return  24;
        } else {
            return size;
        }
    }

    /**
     * Sets the value of the size property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getSize()
     */
    public void setSize(int value) {
        this.size = value;
    }

    public boolean isSetSize() {
        return (this.size!= null);
    }

    public void unsetSize() {
        this.size = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the font color. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColor() {
        if (color == null) {
            return "#A0A0A0";
        } else {
            return color;
        }
    }

    /**
     * Sets the value of the color property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getColor()
     */
    public void setColor(String value) {
        this.color = value;
    }

    public boolean isSetColor() {
        return (this.color!= null);
    }

}
