
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p395319_="https://jakarta.ee/xml/ns/jaxb" xmlns:p806920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the format for exporting the data in a PDF form:&#13;
 *                     &lt;ul&gt;&lt;li&gt;xml = XML&lt;/li&gt;&lt;li&gt;fdf = FDF&lt;/li&gt;&lt;li&gt;xfdf = XFDF&lt;/li&gt;&lt;li&gt;xdp = XDP (only for PDF documents that contain XFA data)&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;The exported data will be returned with the web service call as per the selected format.&lt;/p&gt;&lt;b&gt;Tip:&lt;/b&gt;&#13;
 *                     The format of this is described by the http://schema.webpdf.de/1.0/form/data.xsd schema.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for FormsFormatType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="FormsFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="xml"/>
 *     <enumeration value="fdf"/>
 *     <enumeration value="xfdf"/>
 *     <enumeration value="xdp"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "FormsFormatType")
@XmlEnum
public enum FormsFormatType {

    @XmlEnumValue("xml")
    XML("xml"),
    @XmlEnumValue("fdf")
    FDF("fdf"),
    @XmlEnumValue("xfdf")
    XFDF("xfdf"),
    @XmlEnumValue("xdp")
    XDP("xdp");
    private final String value;

    FormsFormatType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static FormsFormatType fromValue(String v) {
        for (FormsFormatType c: FormsFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
