
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p395319_="https://jakarta.ee/xml/ns/jaxb" xmlns:p806920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to export data from the form fields.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for FormsExportType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="FormsExportType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}FormsBaseType">
 *       <attribute name="format" type="{http://schema.webpdf.de/1.0/operation}FormsFormatType" default="xml" />
 *       <attribute name="fdfFileName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FormsExportType")
public class FormsExportType
    extends FormsBaseType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p395319_="https://jakarta.ee/xml/ns/jaxb" xmlns:p806920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the format for exporting the data in a PDF form:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;xml = XML&lt;/li&gt;&lt;li&gt;fdf = FDF&lt;/li&gt;&lt;li&gt;xfdf = XFDF&lt;/li&gt;&lt;li&gt;xdp = XDP (only for PDF documents that contain XFA data)&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;The exported data will be returned with the web service call as per the selected format.&lt;/p&gt;&lt;b&gt;Tip:&lt;/b&gt;&#13;
     *                                 The format of this is described by the http://schema.webpdf.de/1.0/form/data.xsd schema.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "format")
    protected FormsFormatType format;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p395319_="https://jakarta.ee/xml/ns/jaxb" xmlns:p806920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the file name of the PDF document that should be loaded automatically when the FDF document is opened. This setting is only used if "format" is set to "fdf".&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fdfFileName")
    protected String fdfFileName;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p395319_="https://jakarta.ee/xml/ns/jaxb" xmlns:p806920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the format for exporting the data in a PDF form:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;xml = XML&lt;/li&gt;&lt;li&gt;fdf = FDF&lt;/li&gt;&lt;li&gt;xfdf = XFDF&lt;/li&gt;&lt;li&gt;xdp = XDP (only for PDF documents that contain XFA data)&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;The exported data will be returned with the web service call as per the selected format.&lt;/p&gt;&lt;b&gt;Tip:&lt;/b&gt;&#13;
     *                                 The format of this is described by the http://schema.webpdf.de/1.0/form/data.xsd schema.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FormsFormatType }
     *     
     */
    public FormsFormatType getFormat() {
        if (format == null) {
            return FormsFormatType.XML;
        } else {
            return format;
        }
    }

    /**
     * Sets the value of the format property.
     * 
     * @param value
     *     allowed object is
     *     {@link FormsFormatType }
     *     
     * @see #getFormat()
     */
    public void setFormat(FormsFormatType value) {
        this.format = value;
    }

    public boolean isSetFormat() {
        return (this.format!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p395319_="https://jakarta.ee/xml/ns/jaxb" xmlns:p806920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the file name of the PDF document that should be loaded automatically when the FDF document is opened. This setting is only used if "format" is set to "fdf".&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFdfFileName() {
        if (fdfFileName == null) {
            return "";
        } else {
            return fdfFileName;
        }
    }

    /**
     * Sets the value of the fdfFileName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFdfFileName()
     */
    public void setFdfFileName(String value) {
        this.fdfFileName = value;
    }

    public boolean isSetFdfFileName() {
        return (this.fdfFileName!= null);
    }

}
