
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the annotation element that should be linked to the file attachment.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     If an "annotation element" is not defined for the "file element," the attachment will be stored at the document level.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for FileAnnotationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="FileAnnotationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="point" type="{http://schema.webpdf.de/1.0/operation}PointType"/>
 *       </all>
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}fileAnnotationGroup"/>
 *       <attribute name="opacity" type="{http://schema.webpdf.de/1.0/operation}OpacityType" default="100" />
 *       <attribute name="color" type="{http://schema.webpdf.de/1.0/operation}RgbColorType" default="#4800FF" />
 *       <attribute name="width" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="height" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FileAnnotationType", propOrder = {

})
public class FileAnnotationType {

    @XmlElement(required = true)
    protected PointType point;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the opacity for the attachment's icon. A percent value between 0 and 100 is allowed, whereby 0 equals the minimum opacity. The higher the value, the more the content of the PDF document will be covered over.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "opacity")
    protected Integer opacity;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation colour will change the main colour of the attachment's icon. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "color")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String color;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is positive, the annotation will be generated with a fixed width corresponding to the value instead of using the dimensions of the specified icon.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "width")
    protected Float width;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is positive, the annotation will be generated with a fixed height corresponding to the value instead of using the dimensions of the specified icon.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "height")
    protected Float height;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page on which the annotation will be generated, i.e., the page where the attachment will be stored.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", the person viewing the document will not be allowed to move the icon for the file attached at the page level.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "lockedPosition")
    protected Boolean lockedPosition;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The text that should be displayed in the pop-up for the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "popupText")
    protected String popupText;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If an attachment is embedded at the page level, this option can be used to specify the icon that should be used to show it:&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The value you use here will define which icon will be used, as well as the basic dimensions for the annotation generated in the PDF.&#13;
     *                         If you use the "None" icon type, a predefined icon will not be used. Instead, this option will only use the dimensions specified in "width" and "height" to generate an annotation with a transparent selection box at the specified position.&#13;
     *                         &lt;ul&gt;&lt;li&gt;graph = Diagram&lt;/li&gt;&lt;li&gt;paperclip = Paper clip&lt;/li&gt;&lt;li&gt;pushPin = Thumb tack&lt;/li&gt;&lt;li&gt;tag = Tag&lt;/li&gt;&lt;li&gt;none = Rectangular selection box&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "icon")
    protected IconsType icon;

    /**
     * Gets the value of the point property.
     * 
     * @return
     *     possible object is
     *     {@link PointType }
     *     
     */
    public PointType getPoint() {
        return point;
    }

    /**
     * Sets the value of the point property.
     * 
     * @param value
     *     allowed object is
     *     {@link PointType }
     *     
     */
    public void setPoint(PointType value) {
        this.point = value;
    }

    public boolean isSetPoint() {
        return (this.point!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the opacity for the attachment's icon. A percent value between 0 and 100 is allowed, whereby 0 equals the minimum opacity. The higher the value, the more the content of the PDF document will be covered over.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getOpacity() {
        if (opacity == null) {
            return  100;
        } else {
            return opacity;
        }
    }

    /**
     * Sets the value of the opacity property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getOpacity()
     */
    public void setOpacity(int value) {
        this.opacity = value;
    }

    public boolean isSetOpacity() {
        return (this.opacity!= null);
    }

    public void unsetOpacity() {
        this.opacity = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation colour will change the main colour of the attachment's icon. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColor() {
        if (color == null) {
            return "#4800FF";
        } else {
            return color;
        }
    }

    /**
     * Sets the value of the color property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getColor()
     */
    public void setColor(String value) {
        this.color = value;
    }

    public boolean isSetColor() {
        return (this.color!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is positive, the annotation will be generated with a fixed width corresponding to the value instead of using the dimensions of the specified icon.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getWidth() {
        if (width == null) {
            return  0.0F;
        } else {
            return width;
        }
    }

    /**
     * Sets the value of the width property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getWidth()
     */
    public void setWidth(float value) {
        this.width = value;
    }

    public boolean isSetWidth() {
        return (this.width!= null);
    }

    public void unsetWidth() {
        this.width = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is positive, the annotation will be generated with a fixed height corresponding to the value instead of using the dimensions of the specified icon.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getHeight() {
        if (height == null) {
            return  0.0F;
        } else {
            return height;
        }
    }

    /**
     * Sets the value of the height property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getHeight()
     */
    public void setHeight(float value) {
        this.height = value;
    }

    public boolean isSetHeight() {
        return (this.height!= null);
    }

    public void unsetHeight() {
        this.height = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page on which the annotation will be generated, i.e., the page where the attachment will be stored.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  1;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", the person viewing the document will not be allowed to move the icon for the file attached at the page level.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isLockedPosition() {
        if (lockedPosition == null) {
            return true;
        } else {
            return lockedPosition;
        }
    }

    /**
     * Sets the value of the lockedPosition property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isLockedPosition()
     */
    public void setLockedPosition(boolean value) {
        this.lockedPosition = value;
    }

    public boolean isSetLockedPosition() {
        return (this.lockedPosition!= null);
    }

    public void unsetLockedPosition() {
        this.lockedPosition = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The text that should be displayed in the pop-up for the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPopupText() {
        if (popupText == null) {
            return "";
        } else {
            return popupText;
        }
    }

    /**
     * Sets the value of the popupText property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPopupText()
     */
    public void setPopupText(String value) {
        this.popupText = value;
    }

    public boolean isSetPopupText() {
        return (this.popupText!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If an attachment is embedded at the page level, this option can be used to specify the icon that should be used to show it:&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p109696_="https://jakarta.ee/xml/ns/jaxb" xmlns:p143530_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The value you use here will define which icon will be used, as well as the basic dimensions for the annotation generated in the PDF.&#13;
     *                         If you use the "None" icon type, a predefined icon will not be used. Instead, this option will only use the dimensions specified in "width" and "height" to generate an annotation with a transparent selection box at the specified position.&#13;
     *                         &lt;ul&gt;&lt;li&gt;graph = Diagram&lt;/li&gt;&lt;li&gt;paperclip = Paper clip&lt;/li&gt;&lt;li&gt;pushPin = Thumb tack&lt;/li&gt;&lt;li&gt;tag = Tag&lt;/li&gt;&lt;li&gt;none = Rectangular selection box&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link IconsType }
     *     
     */
    public IconsType getIcon() {
        if (icon == null) {
            return IconsType.PAPERCLIP;
        } else {
            return icon;
        }
    }

    /**
     * Sets the value of the icon property.
     * 
     * @param value
     *     allowed object is
     *     {@link IconsType }
     *     
     * @see #getIcon()
     */
    public void setIcon(IconsType value) {
        this.icon = value;
    }

    public boolean isSetIcon() {
        return (this.icon!= null);
    }

}
