
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;All annotation elements have a number of basic attributes in common. These attributes are described by this base type.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BaseAnnotationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BaseAnnotationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}FlagsAnnotationGroup"/>
 *       <attribute name="creator" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="subject" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="contents" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="intents" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="page" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="color" type="{http://schema.webpdf.de/1.0/operation}RgbColorType" default="#4800FF" />
 *       <attribute name="opacity" type="{http://schema.webpdf.de/1.0/operation}OpacityType" default="100" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BaseAnnotationType")
@XmlSeeAlso({
    TextAnnotationType.class,
    MarkupAnnotationType.class,
    RedactAnnotationType.class,
    FreeTextAnnotationType.class,
    RubberStampAnnotationType.class,
    SimpleShapeAnnotationType.class,
    LineAnnotationType.class
})
public class BaseAnnotationType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the author of the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "creator")
    protected String creator;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the name of the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "name")
    protected String name;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the subject of the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "subject")
    protected String subject;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is used to configure the text content of the annotation, with the way in which it is displayed depending heavily on the specific annotation type (for example, in the case of a text note, this would be the text content of the annotation's popup).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "contents")
    protected String contents;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the intention of the annotation.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         The intention of an annotation can directly influence it's behaviour and may serve different purposes for different annotation types. Only set this directly, if you know it is necessary and possible to do so.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "intents")
    protected String intents;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Set the number of the page, the annotation shall be placed on.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation color will change the main color of visible annotations. The color needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "color")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String color;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This percentage value is used to set the annotation's transparency.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "opacity")
    protected Integer opacity;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be locked so that no changes can be made to it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "locked")
    protected Boolean locked;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be included when the page is printed out.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printable")
    protected Boolean printable;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "rotatable")
    protected Boolean rotatable;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be shown on the document's page.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "viewable")
    protected Boolean viewable;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, it will be possible to change the annotation's contents later on.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "writable")
    protected Boolean writable;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "zoomable")
    protected Boolean zoomable;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "invisible")
    protected Boolean invisible;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will not be shown on the page and will not be printed either.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "hidden")
    protected Boolean hidden;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the author of the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCreator() {
        if (creator == null) {
            return "";
        } else {
            return creator;
        }
    }

    /**
     * Sets the value of the creator property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCreator()
     */
    public void setCreator(String value) {
        this.creator = value;
    }

    public boolean isSetCreator() {
        return (this.creator!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the name of the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        if (name == null) {
            return "";
        } else {
            return name;
        }
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    public void setName(String value) {
        this.name = value;
    }

    public boolean isSetName() {
        return (this.name!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the subject of the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubject() {
        if (subject == null) {
            return "";
        } else {
            return subject;
        }
    }

    /**
     * Sets the value of the subject property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSubject()
     */
    public void setSubject(String value) {
        this.subject = value;
    }

    public boolean isSetSubject() {
        return (this.subject!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is used to configure the text content of the annotation, with the way in which it is displayed depending heavily on the specific annotation type (for example, in the case of a text note, this would be the text content of the annotation's popup).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getContents() {
        if (contents == null) {
            return "";
        } else {
            return contents;
        }
    }

    /**
     * Sets the value of the contents property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getContents()
     */
    public void setContents(String value) {
        this.contents = value;
    }

    public boolean isSetContents() {
        return (this.contents!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the intention of the annotation.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         The intention of an annotation can directly influence it's behaviour and may serve different purposes for different annotation types. Only set this directly, if you know it is necessary and possible to do so.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIntents() {
        if (intents == null) {
            return "";
        } else {
            return intents;
        }
    }

    /**
     * Sets the value of the intents property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getIntents()
     */
    public void setIntents(String value) {
        this.intents = value;
    }

    public boolean isSetIntents() {
        return (this.intents!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Set the number of the page, the annotation shall be placed on.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  1;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation color will change the main color of visible annotations. The color needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColor() {
        if (color == null) {
            return "#4800FF";
        } else {
            return color;
        }
    }

    /**
     * Sets the value of the color property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getColor()
     */
    public void setColor(String value) {
        this.color = value;
    }

    public boolean isSetColor() {
        return (this.color!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This percentage value is used to set the annotation's transparency.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getOpacity() {
        if (opacity == null) {
            return  100;
        } else {
            return opacity;
        }
    }

    /**
     * Sets the value of the opacity property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getOpacity()
     */
    public void setOpacity(int value) {
        this.opacity = value;
    }

    public boolean isSetOpacity() {
        return (this.opacity!= null);
    }

    public void unsetOpacity() {
        this.opacity = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be locked so that no changes can be made to it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isLocked() {
        if (locked == null) {
            return true;
        } else {
            return locked;
        }
    }

    /**
     * Sets the value of the locked property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isLocked()
     */
    public void setLocked(boolean value) {
        this.locked = value;
    }

    public boolean isSetLocked() {
        return (this.locked!= null);
    }

    public void unsetLocked() {
        this.locked = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be included when the page is printed out.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isPrintable() {
        if (printable == null) {
            return false;
        } else {
            return printable;
        }
    }

    /**
     * Sets the value of the printable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isPrintable()
     */
    public void setPrintable(boolean value) {
        this.printable = value;
    }

    public boolean isSetPrintable() {
        return (this.printable!= null);
    }

    public void unsetPrintable() {
        this.printable = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRotatable() {
        if (rotatable == null) {
            return true;
        } else {
            return rotatable;
        }
    }

    /**
     * Sets the value of the rotatable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isRotatable()
     */
    public void setRotatable(boolean value) {
        this.rotatable = value;
    }

    public boolean isSetRotatable() {
        return (this.rotatable!= null);
    }

    public void unsetRotatable() {
        this.rotatable = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be shown on the document's page.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isViewable() {
        if (viewable == null) {
            return true;
        } else {
            return viewable;
        }
    }

    /**
     * Sets the value of the viewable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isViewable()
     */
    public void setViewable(boolean value) {
        this.viewable = value;
    }

    public boolean isSetViewable() {
        return (this.viewable!= null);
    }

    public void unsetViewable() {
        this.viewable = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, it will be possible to change the annotation's contents later on.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isWritable() {
        if (writable == null) {
            return true;
        } else {
            return writable;
        }
    }

    /**
     * Sets the value of the writable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isWritable()
     */
    public void setWritable(boolean value) {
        this.writable = value;
    }

    public boolean isSetWritable() {
        return (this.writable!= null);
    }

    public void unsetWritable() {
        this.writable = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isZoomable() {
        if (zoomable == null) {
            return true;
        } else {
            return zoomable;
        }
    }

    /**
     * Sets the value of the zoomable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isZoomable()
     */
    public void setZoomable(boolean value) {
        this.zoomable = value;
    }

    public boolean isSetZoomable() {
        return (this.zoomable!= null);
    }

    public void unsetZoomable() {
        this.zoomable = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isInvisible() {
        if (invisible == null) {
            return false;
        } else {
            return invisible;
        }
    }

    /**
     * Sets the value of the invisible property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isInvisible()
     */
    public void setInvisible(boolean value) {
        this.invisible = value;
    }

    public boolean isSetInvisible() {
        return (this.invisible!= null);
    }

    public void unsetInvisible() {
        this.invisible = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the annotation will not be shown on the page and will not be printed either.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHidden() {
        if (hidden == null) {
            return false;
        } else {
            return hidden;
        }
    }

    /**
     * Sets the value of the hidden property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isHidden()
     */
    public void setHidden(boolean value) {
        this.hidden = value;
    }

    public boolean isSetHidden() {
        return (this.hidden!= null);
    }

    public void unsetHidden() {
        this.hidden = null;
    }

}
