/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The server element defines settings for the server such as the ports, user sources or authorization settings. Some of these changes might require a server restart to take effect.
 */
@Schema(description = "The server element defines settings for the server such as the ports, user sources or authorization settings. Some of these changes might require a server restart to take effect.")
@JsonPropertyOrder({
  ServerConfigServer.JSON_PROPERTY_APR,
  ServerConfigServer.JSON_PROPERTY_CONNECTORS,
  ServerConfigServer.JSON_PROPERTY_HOST,
  ServerConfigServer.JSON_PROPERTY_LOCAL_AUTH,
  ServerConfigServer.JSON_PROPERTY_OAUTH,
  ServerConfigServer.JSON_PROPERTY_SHUTDOWN,
  ServerConfigServer.JSON_PROPERTY_TRUSTSTORE,
  ServerConfigServer.JSON_PROPERTY_USER
})
@JsonTypeName("ServerConfig_Server")

public class ServerConfigServer {
  public static final String JSON_PROPERTY_APR = "apr";
  private ServerConfigApr apr;

  public static final String JSON_PROPERTY_CONNECTORS = "connectors";
  private ServerConfigConnectorsServer connectors;

  public static final String JSON_PROPERTY_HOST = "host";
  private ServerConfigHost host;

  public static final String JSON_PROPERTY_LOCAL_AUTH = "localAuth";
  private ServerConfigLocalAuth localAuth;

  public static final String JSON_PROPERTY_OAUTH = "oauth";
  private ServerConfigOAuth oauth;

  public static final String JSON_PROPERTY_SHUTDOWN = "shutdown";
  private ServerConfigShutdown shutdown;

  public static final String JSON_PROPERTY_TRUSTSTORE = "truststore";
  private ServerConfigTruststoreServer truststore;

  public static final String JSON_PROPERTY_USER = "user";
  private ServerConfigUserStorage user;

  public ServerConfigServer() {
  }

  public ServerConfigServer apr(ServerConfigApr apr) {
    
    this.apr = apr;
    return this;
  }

  /**
   * Get apr
   * @return apr
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_APR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigApr getApr() {
    return apr;
  }


  @JsonProperty(JSON_PROPERTY_APR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApr(ServerConfigApr apr) {
    this.apr = apr;
  }


  public ServerConfigServer connectors(ServerConfigConnectorsServer connectors) {
    
    this.connectors = connectors;
    return this;
  }

  /**
   * Get connectors
   * @return connectors
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_CONNECTORS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ServerConfigConnectorsServer getConnectors() {
    return connectors;
  }


  @JsonProperty(JSON_PROPERTY_CONNECTORS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setConnectors(ServerConfigConnectorsServer connectors) {
    this.connectors = connectors;
  }


  public ServerConfigServer host(ServerConfigHost host) {
    
    this.host = host;
    return this;
  }

  /**
   * Get host
   * @return host
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_HOST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ServerConfigHost getHost() {
    return host;
  }


  @JsonProperty(JSON_PROPERTY_HOST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHost(ServerConfigHost host) {
    this.host = host;
  }


  public ServerConfigServer localAuth(ServerConfigLocalAuth localAuth) {
    
    this.localAuth = localAuth;
    return this;
  }

  /**
   * Get localAuth
   * @return localAuth
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_LOCAL_AUTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigLocalAuth getLocalAuth() {
    return localAuth;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_AUTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalAuth(ServerConfigLocalAuth localAuth) {
    this.localAuth = localAuth;
  }


  public ServerConfigServer oauth(ServerConfigOAuth oauth) {
    
    this.oauth = oauth;
    return this;
  }

  /**
   * Get oauth
   * @return oauth
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_OAUTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigOAuth getOauth() {
    return oauth;
  }


  @JsonProperty(JSON_PROPERTY_OAUTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOauth(ServerConfigOAuth oauth) {
    this.oauth = oauth;
  }


  public ServerConfigServer shutdown(ServerConfigShutdown shutdown) {
    
    this.shutdown = shutdown;
    return this;
  }

  /**
   * Get shutdown
   * @return shutdown
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_SHUTDOWN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ServerConfigShutdown getShutdown() {
    return shutdown;
  }


  @JsonProperty(JSON_PROPERTY_SHUTDOWN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setShutdown(ServerConfigShutdown shutdown) {
    this.shutdown = shutdown;
  }


  public ServerConfigServer truststore(ServerConfigTruststoreServer truststore) {
    
    this.truststore = truststore;
    return this;
  }

  /**
   * Get truststore
   * @return truststore
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TRUSTSTORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigTruststoreServer getTruststore() {
    return truststore;
  }


  @JsonProperty(JSON_PROPERTY_TRUSTSTORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTruststore(ServerConfigTruststoreServer truststore) {
    this.truststore = truststore;
  }


  public ServerConfigServer user(ServerConfigUserStorage user) {
    
    this.user = user;
    return this;
  }

  /**
   * Get user
   * @return user
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ServerConfigUserStorage getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(ServerConfigUserStorage user) {
    this.user = user;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServerConfigServer serverConfigServer = (ServerConfigServer) o;
    return Objects.equals(this.apr, serverConfigServer.apr) &&
        Objects.equals(this.connectors, serverConfigServer.connectors) &&
        Objects.equals(this.host, serverConfigServer.host) &&
        Objects.equals(this.localAuth, serverConfigServer.localAuth) &&
        Objects.equals(this.oauth, serverConfigServer.oauth) &&
        Objects.equals(this.shutdown, serverConfigServer.shutdown) &&
        Objects.equals(this.truststore, serverConfigServer.truststore) &&
        Objects.equals(this.user, serverConfigServer.user);
  }

  @Override
  public int hashCode() {
    return Objects.hash(apr, connectors, host, localAuth, oauth, shutdown, truststore, user);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServerConfigServer {\n");
    sb.append("    apr: ").append(toIndentedString(apr)).append("\n");
    sb.append("    connectors: ").append(toIndentedString(connectors)).append("\n");
    sb.append("    host: ").append(toIndentedString(host)).append("\n");
    sb.append("    localAuth: ").append(toIndentedString(localAuth)).append("\n");
    sb.append("    oauth: ").append(toIndentedString(oauth)).append("\n");
    sb.append("    shutdown: ").append(toIndentedString(shutdown)).append("\n");
    sb.append("    truststore: ").append(toIndentedString(truststore)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
