/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * ZUGFeRD file (XML) in \&quot;Base64 encoded\&quot; format. The ZUGFeRD XSD schema will be used to validate the file before embedding. If it is not valid, the operation will be aborted.
 */
@Schema(description = "ZUGFeRD file (XML) in \"Base64 encoded\" format. The ZUGFeRD XSD schema will be used to validate the file before embedding. If it is not valid, the operation will be aborted.")
@JsonPropertyOrder({
  OperationZugferdFileData.JSON_PROPERTY_SOURCE,
  OperationZugferdFileData.JSON_PROPERTY_URI,
  OperationZugferdFileData.JSON_PROPERTY_VALUE,
  OperationZugferdFileData.JSON_PROPERTY_VERSION
})
@JsonTypeName("Operation_ZugferdFileData")

public class OperationZugferdFileData {
  /**
   * Selects the data source for the hereby expressed resource. Possible values are:  *   value &#x3D; The element&#39;s value shall contain the BASE64 encoded data. *   uri &#x3D; The data shall be located at the given uri.
   */
  public enum SourceEnum {
    VALUE(String.valueOf("value")),
    
    URI(String.valueOf("uri"));

    private String value;

    SourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SourceEnum fromValue(String value) {
      for (SourceEnum b : SourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOURCE = "source";
  private SourceEnum source = SourceEnum.VALUE;

  public static final String JSON_PROPERTY_URI = "uri";
  private String uri = "";

  public static final String JSON_PROPERTY_VALUE = "value";
  private byte[] value;

  /**
   * Used to define the version of the ZUGFeRD XML file that should be embedded with \&quot;xmlFile\&quot;. Versions from 1.0 to 2.3 are supported. Only the \&quot;Comfort\&quot; profile is available for version 1.0. Meanwhile, the \&quot;Minimum\&quot;, \&quot;Basic WL\&quot;, \&quot;Basic\&quot;, \&quot;EN16931\&quot; (Comfort), and \&quot;Extended\&quot; profiles are supported for version 2.0.  **Note:** Since version 2.x, the referenced profile \&quot;XRECHNUNG\&quot; is additionally available. This profile has been included specifically to include invoices for Germany, based on and under the sole responsibility of KoSIT, Germany&#39;s central coordination agency for IT&#39;s e-invoice CIUS \&quot;XRechnung\&quot;. It is defined as the Standard for electronic invoices issued to public administrations, and essentially adds specific business rules to EN 16931 in order to comply with national laws and regulations.  **Note:** Since version 2.1.1 ZUGFeRD and Factur-X are technically identical, and both formats use Factur-X as common identification.  List of versions with the corresponding profiles:  *   v10Comfort *   v20Minimum *   v20BasicWL *   v20Basic *   v20EN16931 *   v20Extended *   v21Minimum *   v21BasicWL *   v21Basic *   v21EN16931 *   v21Extended *   v21XRechnung *   v22Minimum *   v22BasicWL *   v22Basic *   v22EN16931 *   v22Extended *   v22XRechnung *   v23Minimum *   v23BasicWL *   v23Basic *   v23EN16931 *   v23Extended *   v23XRechnung
   */
  public enum VersionEnum {
    V10_COMFORT(String.valueOf("v10Comfort")),
    
    V20_MINIMUM(String.valueOf("v20Minimum")),
    
    V20_BASIC_WL(String.valueOf("v20BasicWL")),
    
    V20_BASIC(String.valueOf("v20Basic")),
    
    V20_EN16931(String.valueOf("v20EN16931")),
    
    V20_EXTENDED(String.valueOf("v20Extended")),
    
    V21_MINIMUM(String.valueOf("v21Minimum")),
    
    V21_BASIC_WL(String.valueOf("v21BasicWL")),
    
    V21_BASIC(String.valueOf("v21Basic")),
    
    V21_EN16931(String.valueOf("v21EN16931")),
    
    V21_EXTENDED(String.valueOf("v21Extended")),
    
    V21_X_RECHNUNG(String.valueOf("v21XRechnung")),
    
    V22_MINIMUM(String.valueOf("v22Minimum")),
    
    V22_BASIC_WL(String.valueOf("v22BasicWL")),
    
    V22_BASIC(String.valueOf("v22Basic")),
    
    V22_EN16931(String.valueOf("v22EN16931")),
    
    V22_EXTENDED(String.valueOf("v22Extended")),
    
    V22_X_RECHNUNG(String.valueOf("v22XRechnung")),
    
    V23_MINIMUM(String.valueOf("v23Minimum")),
    
    V23_BASIC_WL(String.valueOf("v23BasicWL")),
    
    V23_BASIC(String.valueOf("v23Basic")),
    
    V23_EN16931(String.valueOf("v23EN16931")),
    
    V23_EXTENDED(String.valueOf("v23Extended")),
    
    V23_X_RECHNUNG(String.valueOf("v23XRechnung"));

    private String value;

    VersionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VersionEnum fromValue(String value) {
      for (VersionEnum b : VersionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VERSION = "version";
  private VersionEnum version = VersionEnum.V10_COMFORT;

  public OperationZugferdFileData() {
  }

  public OperationZugferdFileData source(SourceEnum source) {
    
    this.source = source;
    return this;
  }

  /**
   * Selects the data source for the hereby expressed resource. Possible values are:  *   value &#x3D; The element&#39;s value shall contain the BASE64 encoded data. *   uri &#x3D; The data shall be located at the given uri.
   * @return source
   **/
  @Nullable
  @Schema(name = "Selects the data source for the hereby expressed resource. Possible values are:  *   value = The element's value shall contain the BASE64 encoded data. *   uri = The data shall be located at the given uri.")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SourceEnum getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(SourceEnum source) {
    this.source = source;
  }


  public OperationZugferdFileData uri(String uri) {
    
    this.uri = uri;
    return this;
  }

  /**
   * The uri the data shall be located at. (This shall only have effect, if the \&quot;source\&quot; is \&quot;uri\&quot;.)
   * @return uri
   **/
  @Nullable
  @Schema(name = "The uri the data shall be located at. (This shall only have effect, if the \"source\" is \"uri\".)")
  @JsonProperty(JSON_PROPERTY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUri() {
    return uri;
  }


  @JsonProperty(JSON_PROPERTY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUri(String uri) {
    this.uri = uri;
  }


  public OperationZugferdFileData value(byte[] value) {
    
    this.value = value;
    return this;
  }

  /**
   * Get value
   * @return value
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public byte[] getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(byte[] value) {
    this.value = value;
  }


  public OperationZugferdFileData version(VersionEnum version) {
    
    this.version = version;
    return this;
  }

  /**
   * Used to define the version of the ZUGFeRD XML file that should be embedded with \&quot;xmlFile\&quot;. Versions from 1.0 to 2.3 are supported. Only the \&quot;Comfort\&quot; profile is available for version 1.0. Meanwhile, the \&quot;Minimum\&quot;, \&quot;Basic WL\&quot;, \&quot;Basic\&quot;, \&quot;EN16931\&quot; (Comfort), and \&quot;Extended\&quot; profiles are supported for version 2.0.  **Note:** Since version 2.x, the referenced profile \&quot;XRECHNUNG\&quot; is additionally available. This profile has been included specifically to include invoices for Germany, based on and under the sole responsibility of KoSIT, Germany&#39;s central coordination agency for IT&#39;s e-invoice CIUS \&quot;XRechnung\&quot;. It is defined as the Standard for electronic invoices issued to public administrations, and essentially adds specific business rules to EN 16931 in order to comply with national laws and regulations.  **Note:** Since version 2.1.1 ZUGFeRD and Factur-X are technically identical, and both formats use Factur-X as common identification.  List of versions with the corresponding profiles:  *   v10Comfort *   v20Minimum *   v20BasicWL *   v20Basic *   v20EN16931 *   v20Extended *   v21Minimum *   v21BasicWL *   v21Basic *   v21EN16931 *   v21Extended *   v21XRechnung *   v22Minimum *   v22BasicWL *   v22Basic *   v22EN16931 *   v22Extended *   v22XRechnung *   v23Minimum *   v23BasicWL *   v23Basic *   v23EN16931 *   v23Extended *   v23XRechnung
   * @return version
   **/
  @Nullable
  @Schema(name = "Used to define the version of the ZUGFeRD XML file that should be embedded with \"xmlFile\". Versions from 1.0 to 2.3 are supported. Only the \"Comfort\" profile is available for version 1.0. Meanwhile, the \"Minimum\", \"Basic WL\", \"Basic\", \"EN16931\" (Comfort), and \"Extended\" profiles are supported for version 2.0.  **Note:** Since version 2.x, the referenced profile \"XRECHNUNG\" is additionally available. This profile has been included specifically to include invoices for Germany, based on and under the sole responsibility of KoSIT, Germany's central coordination agency for IT's e-invoice CIUS \"XRechnung\". It is defined as the Standard for electronic invoices issued to public administrations, and essentially adds specific business rules to EN 16931 in order to comply with national laws and regulations.  **Note:** Since version 2.1.1 ZUGFeRD and Factur-X are technically identical, and both formats use Factur-X as common identification.  List of versions with the corresponding profiles:  *   v10Comfort *   v20Minimum *   v20BasicWL *   v20Basic *   v20EN16931 *   v20Extended *   v21Minimum *   v21BasicWL *   v21Basic *   v21EN16931 *   v21Extended *   v21XRechnung *   v22Minimum *   v22BasicWL *   v22Basic *   v22EN16931 *   v22Extended *   v22XRechnung *   v23Minimum *   v23BasicWL *   v23Basic *   v23EN16931 *   v23Extended *   v23XRechnung")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VersionEnum getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(VersionEnum version) {
    this.version = version;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationZugferdFileData operationZugferdFileData = (OperationZugferdFileData) o;
    return Objects.equals(this.source, operationZugferdFileData.source) &&
        Objects.equals(this.uri, operationZugferdFileData.uri) &&
        Arrays.equals(this.value, operationZugferdFileData.value) &&
        Objects.equals(this.version, operationZugferdFileData.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(source, uri, Arrays.hashCode(value), version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationZugferdFileData {\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
