/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Sets the page size, margins, and headers and footers for the converted document in the PDF document.  **Important:** The settings may override the default values for a format that itself has page settings. In addition, not all settings can be applied to all formats (see, for example, the description of headers and footers).
 */
@Schema(description = "Sets the page size, margins, and headers and footers for the converted document in the PDF document.  **Important:** The settings may override the default values for a format that itself has page settings. In addition, not all settings can be applied to all formats (see, for example, the description of headers and footers).")
@JsonPropertyOrder({
  OperationUrlConverterPage.JSON_PROPERTY_BOTTOM,
  OperationUrlConverterPage.JSON_PROPERTY_FOOTER,
  OperationUrlConverterPage.JSON_PROPERTY_HEADER,
  OperationUrlConverterPage.JSON_PROPERTY_HEIGHT,
  OperationUrlConverterPage.JSON_PROPERTY_LEFT,
  OperationUrlConverterPage.JSON_PROPERTY_METRICS,
  OperationUrlConverterPage.JSON_PROPERTY_RIGHT,
  OperationUrlConverterPage.JSON_PROPERTY_TOP,
  OperationUrlConverterPage.JSON_PROPERTY_WIDTH
})
@JsonTypeName("Operation_UrlConverterPage")

public class OperationUrlConverterPage {
  public static final String JSON_PROPERTY_BOTTOM = "bottom";
  private Integer bottom = 20;

  public static final String JSON_PROPERTY_FOOTER = "footer";
  private OperationUrlConverterFooter footer;

  public static final String JSON_PROPERTY_HEADER = "header";
  private OperationUrlConverterHeader header;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Integer height = 297;

  public static final String JSON_PROPERTY_LEFT = "left";
  private Integer left = 20;

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   */
  public enum MetricsEnum {
    PT(String.valueOf("pt")),
    
    PC(String.valueOf("pc")),
    
    PX(String.valueOf("px")),
    
    MM(String.valueOf("mm")),
    
    IN(String.valueOf("in"));

    private String value;

    MetricsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MetricsEnum fromValue(String value) {
      for (MetricsEnum b : MetricsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_METRICS = "metrics";
  private MetricsEnum metrics = MetricsEnum.MM;

  public static final String JSON_PROPERTY_RIGHT = "right";
  private Integer right = 20;

  public static final String JSON_PROPERTY_TOP = "top";
  private Integer top = 20;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Integer width = 210;

  public OperationUrlConverterPage() {
  }

  public OperationUrlConverterPage bottom(Integer bottom) {
    
    this.bottom = bottom;
    return this;
  }

  /**
   * Bottom margin settings.
   * @return bottom
   **/
  @Nullable
  @Schema(name = "Bottom margin settings.")
  @JsonProperty(JSON_PROPERTY_BOTTOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBottom() {
    return bottom;
  }


  @JsonProperty(JSON_PROPERTY_BOTTOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBottom(Integer bottom) {
    this.bottom = bottom;
  }


  public OperationUrlConverterPage footer(OperationUrlConverterFooter footer) {
    
    this.footer = footer;
    return this;
  }

  /**
   * Get footer
   * @return footer
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationUrlConverterFooter getFooter() {
    return footer;
  }


  @JsonProperty(JSON_PROPERTY_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFooter(OperationUrlConverterFooter footer) {
    this.footer = footer;
  }


  public OperationUrlConverterPage header(OperationUrlConverterHeader header) {
    
    this.header = header;
    return this;
  }

  /**
   * Get header
   * @return header
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_HEADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationUrlConverterHeader getHeader() {
    return header;
  }


  @JsonProperty(JSON_PROPERTY_HEADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeader(OperationUrlConverterHeader header) {
    this.header = header;
  }


  public OperationUrlConverterPage height(Integer height) {
    
    this.height = height;
    return this;
  }

  /**
   * Page height.
   * @return height
   **/
  @Nullable
  @Schema(name = "Page height.")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeight(Integer height) {
    this.height = height;
  }


  public OperationUrlConverterPage left(Integer left) {
    
    this.left = left;
    return this;
  }

  /**
   * Left margin settings.
   * @return left
   **/
  @Nullable
  @Schema(name = "Left margin settings.")
  @JsonProperty(JSON_PROPERTY_LEFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLeft() {
    return left;
  }


  @JsonProperty(JSON_PROPERTY_LEFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLeft(Integer left) {
    this.left = left;
  }


  public OperationUrlConverterPage metrics(MetricsEnum metrics) {
    
    this.metrics = metrics;
    return this;
  }

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   * @return metrics
   **/
  @Nullable
  @Schema(name = "Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetricsEnum getMetrics() {
    return metrics;
  }


  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetrics(MetricsEnum metrics) {
    this.metrics = metrics;
  }


  public OperationUrlConverterPage right(Integer right) {
    
    this.right = right;
    return this;
  }

  /**
   * Right margin settings.
   * @return right
   **/
  @Nullable
  @Schema(name = "Right margin settings.")
  @JsonProperty(JSON_PROPERTY_RIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRight() {
    return right;
  }


  @JsonProperty(JSON_PROPERTY_RIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRight(Integer right) {
    this.right = right;
  }


  public OperationUrlConverterPage top(Integer top) {
    
    this.top = top;
    return this;
  }

  /**
   * Top margin settings.
   * @return top
   **/
  @Nullable
  @Schema(name = "Top margin settings.")
  @JsonProperty(JSON_PROPERTY_TOP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTop() {
    return top;
  }


  @JsonProperty(JSON_PROPERTY_TOP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTop(Integer top) {
    this.top = top;
  }


  public OperationUrlConverterPage width(Integer width) {
    
    this.width = width;
    return this;
  }

  /**
   * Page width.
   * @return width
   **/
  @Nullable
  @Schema(name = "Page width.")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(Integer width) {
    this.width = width;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationUrlConverterPage operationUrlConverterPage = (OperationUrlConverterPage) o;
    return Objects.equals(this.bottom, operationUrlConverterPage.bottom) &&
        Objects.equals(this.footer, operationUrlConverterPage.footer) &&
        Objects.equals(this.header, operationUrlConverterPage.header) &&
        Objects.equals(this.height, operationUrlConverterPage.height) &&
        Objects.equals(this.left, operationUrlConverterPage.left) &&
        Objects.equals(this.metrics, operationUrlConverterPage.metrics) &&
        Objects.equals(this.right, operationUrlConverterPage.right) &&
        Objects.equals(this.top, operationUrlConverterPage.top) &&
        Objects.equals(this.width, operationUrlConverterPage.width);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bottom, footer, header, height, left, metrics, right, top, width);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationUrlConverterPage {\n");
    sb.append("    bottom: ").append(toIndentedString(bottom)).append("\n");
    sb.append("    footer: ").append(toIndentedString(footer)).append("\n");
    sb.append("    header: ").append(toIndentedString(header)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    left: ").append(toIndentedString(left)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    right: ").append(toIndentedString(right)).append("\n");
    sb.append("    top: ").append(toIndentedString(top)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
