/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The split operation element can be used to split documents.  **Important:** Acroforms are correctly split, but contained XFA data are removed.
 */
@Schema(description = "The split operation element can be used to split documents.  **Important:** Acroforms are correctly split, but contained XFA data are removed.")
@JsonPropertyOrder({
  OperationToolboxSplitSplit.JSON_PROPERTY_FILE_NAME_TEMPLATE,
  OperationToolboxSplitSplit.JSON_PROPERTY_MODE,
  OperationToolboxSplitSplit.JSON_PROPERTY_PAGES,
  OperationToolboxSplitSplit.JSON_PROPERTY_SINGLE_FILE_AS_ZIP,
  OperationToolboxSplitSplit.JSON_PROPERTY_START_PAGE
})
@JsonTypeName("Operation_ToolboxSplit_split")

public class OperationToolboxSplitSplit {
  public static final String JSON_PROPERTY_FILE_NAME_TEMPLATE = "fileNameTemplate";
  private String fileNameTemplate = "page[%d]";

  /**
   * Defines the mode used to split the PDF document.  *   last &#x3D; Last page - Uses \&quot;pages\&quot; to define the last page that will be contained in the new PDF document. *   first &#x3D; First page - Uses \&quot;pages\&quot; to define the first page that will be contained in the new PDF document. *   list &#x3D; List of pages - Uses \&quot;pages\&quot; to define a list of pages that should be extracted from the document. A single PDF document will be created on the basis of this list. *   single &#x3D; Selected pages - Uses the \&quot;pages\&quot; attribute to define a list of pages that should be extracted from the document. And creates a ZIP file with the corresponding pages. *   each &#x3D; Every nth page - Uses the \&quot;pages\&quot; attribute to define the interval at which pages should be extracted. The \&quot;startPage\&quot; attribute is used to define the page on which the process will start. The result will be a ZIP file. *   group &#x3D; Group pages - Multiple pages will be added to a single PDF document. The \&quot;pages\&quot; attribute can be used to define how many pages will be saved in a single PDF document. The \&quot;startPage\&quot; attribute is used to define the page on which the process will start. The result will be a ZIP file. *   burst &#x3D; Ungroup pages - A new PDF document will be generated from each page. The result will be a ZIP file.
   */
  public enum ModeEnum {
    LAST(String.valueOf("last")),
    
    FIRST(String.valueOf("first")),
    
    LIST(String.valueOf("list")),
    
    SINGLE(String.valueOf("single")),
    
    EACH(String.valueOf("each")),
    
    GROUP(String.valueOf("group")),
    
    BURST(String.valueOf("burst"));

    private String value;

    ModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ModeEnum fromValue(String value) {
      for (ModeEnum b : ModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MODE = "mode";
  private ModeEnum mode = ModeEnum.LAST;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "1";

  public static final String JSON_PROPERTY_SINGLE_FILE_AS_ZIP = "singleFileAsZip";
  private Boolean singleFileAsZip = true;

  public static final String JSON_PROPERTY_START_PAGE = "startPage";
  private Integer startPage = 1;

  public OperationToolboxSplitSplit() {
  }

  public OperationToolboxSplitSplit fileNameTemplate(String fileNameTemplate) {
    
    this.fileNameTemplate = fileNameTemplate;
    return this;
  }

  /**
   * If the \&quot;split\&quot; operation generates a ZIP document (please refer to \&quot;mode\&quot;), this template can be used to define the file name of the PDF document in the ZIP document. The \&quot;%d\&quot; placeholder must be used in the template in order to define the PDF document page.
   * @return fileNameTemplate
   **/
  @Nullable
  @Schema(name = "If the \"split\" operation generates a ZIP document (please refer to \"mode\"), this template can be used to define the file name of the PDF document in the ZIP document. The \"%d\" placeholder must be used in the template in order to define the PDF document page.")
  @JsonProperty(JSON_PROPERTY_FILE_NAME_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileNameTemplate() {
    return fileNameTemplate;
  }


  @JsonProperty(JSON_PROPERTY_FILE_NAME_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileNameTemplate(String fileNameTemplate) {
    this.fileNameTemplate = fileNameTemplate;
  }


  public OperationToolboxSplitSplit mode(ModeEnum mode) {
    
    this.mode = mode;
    return this;
  }

  /**
   * Defines the mode used to split the PDF document.  *   last &#x3D; Last page - Uses \&quot;pages\&quot; to define the last page that will be contained in the new PDF document. *   first &#x3D; First page - Uses \&quot;pages\&quot; to define the first page that will be contained in the new PDF document. *   list &#x3D; List of pages - Uses \&quot;pages\&quot; to define a list of pages that should be extracted from the document. A single PDF document will be created on the basis of this list. *   single &#x3D; Selected pages - Uses the \&quot;pages\&quot; attribute to define a list of pages that should be extracted from the document. And creates a ZIP file with the corresponding pages. *   each &#x3D; Every nth page - Uses the \&quot;pages\&quot; attribute to define the interval at which pages should be extracted. The \&quot;startPage\&quot; attribute is used to define the page on which the process will start. The result will be a ZIP file. *   group &#x3D; Group pages - Multiple pages will be added to a single PDF document. The \&quot;pages\&quot; attribute can be used to define how many pages will be saved in a single PDF document. The \&quot;startPage\&quot; attribute is used to define the page on which the process will start. The result will be a ZIP file. *   burst &#x3D; Ungroup pages - A new PDF document will be generated from each page. The result will be a ZIP file.
   * @return mode
   **/
  @Nullable
  @Schema(name = "Defines the mode used to split the PDF document.  *   last = Last page - Uses \"pages\" to define the last page that will be contained in the new PDF document. *   first = First page - Uses \"pages\" to define the first page that will be contained in the new PDF document. *   list = List of pages - Uses \"pages\" to define a list of pages that should be extracted from the document. A single PDF document will be created on the basis of this list. *   single = Selected pages - Uses the \"pages\" attribute to define a list of pages that should be extracted from the document. And creates a ZIP file with the corresponding pages. *   each = Every nth page - Uses the \"pages\" attribute to define the interval at which pages should be extracted. The \"startPage\" attribute is used to define the page on which the process will start. The result will be a ZIP file. *   group = Group pages - Multiple pages will be added to a single PDF document. The \"pages\" attribute can be used to define how many pages will be saved in a single PDF document. The \"startPage\" attribute is used to define the page on which the process will start. The result will be a ZIP file. *   burst = Ungroup pages - A new PDF document will be generated from each page. The result will be a ZIP file.")
  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ModeEnum getMode() {
    return mode;
  }


  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMode(ModeEnum mode) {
    this.mode = mode;
  }


  public OperationToolboxSplitSplit pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * Defines which page(s) should be used for the split operation. The page number can be an individual page, a page range, or a list (separated with commas) (e.g. \&quot;1,5-6,9\&quot;). The \&quot;mode\&quot; attribute defines whether a single page or a range of pages can be used: With \&quot;last\&quot; and \&quot;first,\&quot; an individual page is specified; with \&quot;list,\&quot; a list of pages can be used.
   * @return pages
   **/
  @Nullable
  @Schema(name = "Defines which page(s) should be used for the split operation. The page number can be an individual page, a page range, or a list (separated with commas) (e.g. \"1,5-6,9\"). The \"mode\" attribute defines whether a single page or a range of pages can be used: With \"last\" and \"first,\" an individual page is specified; with \"list,\" a list of pages can be used.")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  public OperationToolboxSplitSplit singleFileAsZip(Boolean singleFileAsZip) {
    
    this.singleFileAsZip = singleFileAsZip;
    return this;
  }

  /**
   * Only mode with \&quot;single\&quot;, \&quot;burst\&quot;, \&quot;each\&quot;, or \&quot;group\&quot;. The returned pages will be generated as a ZIP file even if selection is used to select only one single file. You can change this behaviour by setting this option to \&quot;false\&quot;. In this case, the page will not be zipped, and will instead be returned directly as is. However, this will only work if selection has been used to select one page and one page only.
   * @return singleFileAsZip
   **/
  @Nullable
  @Schema(name = "Only mode with \"single\", \"burst\", \"each\", or \"group\". The returned pages will be generated as a ZIP file even if selection is used to select only one single file. You can change this behaviour by setting this option to \"false\". In this case, the page will not be zipped, and will instead be returned directly as is. However, this will only work if selection has been used to select one page and one page only.")
  @JsonProperty(JSON_PROPERTY_SINGLE_FILE_AS_ZIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSingleFileAsZip() {
    return singleFileAsZip;
  }


  @JsonProperty(JSON_PROPERTY_SINGLE_FILE_AS_ZIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSingleFileAsZip(Boolean singleFileAsZip) {
    this.singleFileAsZip = singleFileAsZip;
  }


  public OperationToolboxSplitSplit startPage(Integer startPage) {
    
    this.startPage = startPage;
    return this;
  }

  /**
   * Used for \&quot;each\&quot; and \&quot;group\&quot; in the \&quot;mode\&quot; attribute.
   * minimum: 1
   * @return startPage
   **/
  @Nullable
  @Schema(name = "Used for \"each\" and \"group\" in the \"mode\" attribute.")
  @JsonProperty(JSON_PROPERTY_START_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStartPage() {
    return startPage;
  }


  @JsonProperty(JSON_PROPERTY_START_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartPage(Integer startPage) {
    this.startPage = startPage;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationToolboxSplitSplit operationToolboxSplitSplit = (OperationToolboxSplitSplit) o;
    return Objects.equals(this.fileNameTemplate, operationToolboxSplitSplit.fileNameTemplate) &&
        Objects.equals(this.mode, operationToolboxSplitSplit.mode) &&
        Objects.equals(this.pages, operationToolboxSplitSplit.pages) &&
        Objects.equals(this.singleFileAsZip, operationToolboxSplitSplit.singleFileAsZip) &&
        Objects.equals(this.startPage, operationToolboxSplitSplit.startPage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fileNameTemplate, mode, pages, singleFileAsZip, startPage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationToolboxSplitSplit {\n");
    sb.append("    fileNameTemplate: ").append(toIndentedString(fileNameTemplate)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    singleFileAsZip: ").append(toIndentedString(singleFileAsZip)).append("\n");
    sb.append("    startPage: ").append(toIndentedString(startPage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
