/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * An element of this type represents the properties of a signature.
 */
@Schema(description = "An element of this type represents the properties of a signature.")
@JsonPropertyOrder({
  MetadataSignature.JSON_PROPERTY_CONTACT,
  MetadataSignature.JSON_PROPERTY_DATE,
  MetadataSignature.JSON_PROPERTY_FILTER,
  MetadataSignature.JSON_PROPERTY_LOCATION,
  MetadataSignature.JSON_PROPERTY_NAME,
  MetadataSignature.JSON_PROPERTY_OBJECT_KEY,
  MetadataSignature.JSON_PROPERTY_REASON,
  MetadataSignature.JSON_PROPERTY_SUB_FILTER
})
@JsonTypeName("Metadata_Signature")

public class MetadataSignature {
  public static final String JSON_PROPERTY_CONTACT = "contact";
  private String contact = "";

  public static final String JSON_PROPERTY_DATE = "date";
  private String date = "";

  public static final String JSON_PROPERTY_FILTER = "filter";
  private String filter = "";

  public static final String JSON_PROPERTY_LOCATION = "location";
  private String location = "";

  public static final String JSON_PROPERTY_NAME = "name";
  private String name = "";

  public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
  private String objectKey = "";

  public static final String JSON_PROPERTY_REASON = "reason";
  private String reason = "";

  public static final String JSON_PROPERTY_SUB_FILTER = "subFilter";
  private String subFilter = "";

  public MetadataSignature() {
  }

  public MetadataSignature contact(String contact) {
    
    this.contact = contact;
    return this;
  }

  /**
   * The contact information provided by the signer.
   * @return contact
   **/
  @Nullable
  @Schema(name = "The contact information provided by the signer.")
  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContact(String contact) {
    this.contact = contact;
  }


  public MetadataSignature date(String date) {
    
    this.date = date;
    return this;
  }

  /**
   * The date the signature has been created.
   * @return date
   **/
  @Nullable
  @Schema(name = "The date the signature has been created.")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(String date) {
    this.date = date;
  }


  public MetadataSignature filter(String filter) {
    
    this.filter = filter;
    return this;
  }

  /**
   * The name of the preferred signature handler used for validation. (Adobe.PPKLite, EntrustPPKEF etc.)
   * @return filter
   **/
  @Nullable
  @Schema(name = "The name of the preferred signature handler used for validation. (Adobe.PPKLite, EntrustPPKEF etc.)")
  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFilter() {
    return filter;
  }


  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilter(String filter) {
    this.filter = filter;
  }


  public MetadataSignature location(String location) {
    
    this.location = location;
    return this;
  }

  /**
   * The location the document has been signed at.
   * @return location
   **/
  @Nullable
  @Schema(name = "The location the document has been signed at.")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(String location) {
    this.location = location;
  }


  public MetadataSignature name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * The name of the person or authority signing the document.
   * @return name
   **/
  @Nullable
  @Schema(name = "The name of the person or authority signing the document.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public MetadataSignature objectKey(String objectKey) {
    
    this.objectKey = objectKey;
    return this;
  }

  /**
   * The object ID of the signature. **Info:** A PDF object ID consists of two numbers, where the first number selects the object&#39;s number and the second the \&quot;generation\&quot; of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.
   * @return objectKey
   **/
  @Nullable
  @Schema(name = "The object ID of the signature. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObjectKey() {
    return objectKey;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObjectKey(String objectKey) {
    this.objectKey = objectKey;
  }


  public MetadataSignature reason(String reason) {
    
    this.reason = reason;
    return this;
  }

  /**
   * The reason for signing the document.
   * @return reason
   **/
  @Nullable
  @Schema(name = "The reason for signing the document.")
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReason() {
    return reason;
  }


  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReason(String reason) {
    this.reason = reason;
  }


  public MetadataSignature subFilter(String subFilter) {
    
    this.subFilter = subFilter;
    return this;
  }

  /**
   * The encoding of the signature value, that shall also be used for validation. (adbe.x509.rsa\\_sha1, adbe.pkcs7.sha1, etc.)
   * @return subFilter
   **/
  @Nullable
  @Schema(name = "The encoding of the signature value, that shall also be used for validation. (adbe.x509.rsa\\_sha1, adbe.pkcs7.sha1, etc.)")
  @JsonProperty(JSON_PROPERTY_SUB_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubFilter() {
    return subFilter;
  }


  @JsonProperty(JSON_PROPERTY_SUB_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubFilter(String subFilter) {
    this.subFilter = subFilter;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataSignature metadataSignature = (MetadataSignature) o;
    return Objects.equals(this.contact, metadataSignature.contact) &&
        Objects.equals(this.date, metadataSignature.date) &&
        Objects.equals(this.filter, metadataSignature.filter) &&
        Objects.equals(this.location, metadataSignature.location) &&
        Objects.equals(this.name, metadataSignature.name) &&
        Objects.equals(this.objectKey, metadataSignature.objectKey) &&
        Objects.equals(this.reason, metadataSignature.reason) &&
        Objects.equals(this.subFilter, metadataSignature.subFilter);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contact, date, filter, location, name, objectKey, reason, subFilter);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataSignature {\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    objectKey: ").append(toIndentedString(objectKey)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    subFilter: ").append(toIndentedString(subFilter)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
