/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Settings for the cluster
 */
@Schema(description = "Settings for the cluster")
@JsonPropertyOrder({
  ClusterSettings.JSON_PROPERTY_CONNECT_TIMEOUT,
  ClusterSettings.JSON_PROPERTY_MODE,
  ClusterSettings.JSON_PROPERTY_NAME,
  ClusterSettings.JSON_PROPERTY_NODE_NAME,
  ClusterSettings.JSON_PROPERTY_ROLE,
  ClusterSettings.JSON_PROPERTY_SECRET_KEY,
  ClusterSettings.JSON_PROPERTY_STOP_ON_ERROR
})
@JsonTypeName("Cluster_Settings")

public class ClusterSettings {
  public static final String JSON_PROPERTY_CONNECT_TIMEOUT = "connectTimeout";
  private Integer connectTimeout = 0;

  public static final String JSON_PROPERTY_MODE = "mode";
  private ClusterMode mode = ClusterMode.SINGLE;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name = "";

  public static final String JSON_PROPERTY_NODE_NAME = "nodeName";
  private String nodeName = "";

  public static final String JSON_PROPERTY_ROLE = "role";
  private ClusterRole role = ClusterRole.MEMBER;

  public static final String JSON_PROPERTY_SECRET_KEY = "secretKey";
  private String secretKey = "";

  public static final String JSON_PROPERTY_STOP_ON_ERROR = "stopOnError";
  private Boolean stopOnError = false;

  public ClusterSettings() {
  }

  public ClusterSettings connectTimeout(Integer connectTimeout) {
    
    this.connectTimeout = connectTimeout;
    return this;
  }

  /**
   * Defines the number of milliseconds that a server node waits when it joins the cluster (e.g. when waiting for a coordinator server node)
   * @return connectTimeout
   **/
  @Nullable
  @Schema(name = "Defines the number of milliseconds that a server node waits when it joins the cluster (e.g. when waiting for a coordinator server node)")
  @JsonProperty(JSON_PROPERTY_CONNECT_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getConnectTimeout() {
    return connectTimeout;
  }


  @JsonProperty(JSON_PROPERTY_CONNECT_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConnectTimeout(Integer connectTimeout) {
    this.connectTimeout = connectTimeout;
  }


  public ClusterSettings mode(ClusterMode mode) {
    
    this.mode = mode;
    return this;
  }

  /**
   * Get mode
   * @return mode
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ClusterMode getMode() {
    return mode;
  }


  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMode(ClusterMode mode) {
    this.mode = mode;
  }


  public ClusterSettings name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Defines the name of the cluster. If the server node has a coordinator role, the cluster is created under this name. If the server node has the role of a member, the node attempts to join the cluster with this name.
   * @return name
   **/
  @Nullable
  @Schema(name = "Defines the name of the cluster. If the server node has a coordinator role, the cluster is created under this name. If the server node has the role of a member, the node attempts to join the cluster with this name.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public ClusterSettings nodeName(String nodeName) {
    
    this.nodeName = nodeName;
    return this;
  }

  /**
   * Defines the name for the node. If it is empty, the host name of the machine is used.
   * @return nodeName
   **/
  @Nullable
  @Schema(name = "Defines the name for the node. If it is empty, the host name of the machine is used.")
  @JsonProperty(JSON_PROPERTY_NODE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNodeName() {
    return nodeName;
  }


  @JsonProperty(JSON_PROPERTY_NODE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNodeName(String nodeName) {
    this.nodeName = nodeName;
  }


  public ClusterSettings role(ClusterRole role) {
    
    this.role = role;
    return this;
  }

  /**
   * Get role
   * @return role
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ROLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ClusterRole getRole() {
    return role;
  }


  @JsonProperty(JSON_PROPERTY_ROLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRole(ClusterRole role) {
    this.role = role;
  }


  public ClusterSettings secretKey(String secretKey) {
    
    this.secretKey = secretKey;
    return this;
  }

  /**
   * The encryption key used for communication in the cluster between the nodes. All nodes must use the same 64-digit hexadecimal encryption key. The encryption key is created when the cluster is initialized.
   * @return secretKey
   **/
  @Nullable
  @Schema(name = "The encryption key used for communication in the cluster between the nodes. All nodes must use the same 64-digit hexadecimal encryption key. The encryption key is created when the cluster is initialized.")
  @JsonProperty(JSON_PROPERTY_SECRET_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSecretKey() {
    return secretKey;
  }


  @JsonProperty(JSON_PROPERTY_SECRET_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecretKey(String secretKey) {
    this.secretKey = secretKey;
  }


  public ClusterSettings stopOnError(Boolean stopOnError) {
    
    this.stopOnError = stopOnError;
    return this;
  }

  /**
   * If &#39;true&#39;, the server node is also started if an error has occurred (e.g. when joining the cluster).
   * @return stopOnError
   **/
  @Nullable
  @Schema(name = "If 'true', the server node is also started if an error has occurred (e.g. when joining the cluster).")
  @JsonProperty(JSON_PROPERTY_STOP_ON_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getStopOnError() {
    return stopOnError;
  }


  @JsonProperty(JSON_PROPERTY_STOP_ON_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStopOnError(Boolean stopOnError) {
    this.stopOnError = stopOnError;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClusterSettings clusterSettings = (ClusterSettings) o;
    return Objects.equals(this.connectTimeout, clusterSettings.connectTimeout) &&
        Objects.equals(this.mode, clusterSettings.mode) &&
        Objects.equals(this.name, clusterSettings.name) &&
        Objects.equals(this.nodeName, clusterSettings.nodeName) &&
        Objects.equals(this.role, clusterSettings.role) &&
        Objects.equals(this.secretKey, clusterSettings.secretKey) &&
        Objects.equals(this.stopOnError, clusterSettings.stopOnError);
  }

  @Override
  public int hashCode() {
    return Objects.hash(connectTimeout, mode, name, nodeName, role, secretKey, stopOnError);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClusterSettings {\n");
    sb.append("    connectTimeout: ").append(toIndentedString(connectTimeout)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    nodeName: ").append(toIndentedString(nodeName)).append("\n");
    sb.append("    role: ").append(toIndentedString(role)).append("\n");
    sb.append("    secretKey: ").append(toIndentedString(secretKey)).append("\n");
    sb.append("    stopOnError: ").append(toIndentedString(stopOnError)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
