/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Returns details about a user in a session
 */
@Schema(description = "Returns details about a user in a session")
@JsonPropertyOrder({
  AuthUserCredentials.JSON_PROPERTY_IS_ADMIN,
  AuthUserCredentials.JSON_PROPERTY_IS_USER,
  AuthUserCredentials.JSON_PROPERTY_ROLES,
  AuthUserCredentials.JSON_PROPERTY_UNIQUE_ID,
  AuthUserCredentials.JSON_PROPERTY_USER_LIMITS,
  AuthUserCredentials.JSON_PROPERTY_USER_NAME
})
@JsonTypeName("Auth_UserCredentials")

public class AuthUserCredentials {
  public static final String JSON_PROPERTY_IS_ADMIN = "isAdmin";
  private Boolean isAdmin = false;

  public static final String JSON_PROPERTY_IS_USER = "isUser";
  private Boolean isUser = true;

  public static final String JSON_PROPERTY_ROLES = "roles";
  private List<String> roles = new ArrayList<>();

  public static final String JSON_PROPERTY_UNIQUE_ID = "uniqueId";
  private String uniqueId = "";

  public static final String JSON_PROPERTY_USER_LIMITS = "userLimits";
  private AuthLimits userLimits;

  public static final String JSON_PROPERTY_USER_NAME = "userName";
  private String userName = "";

  public AuthUserCredentials() {
  }

  @JsonCreator
  public AuthUserCredentials(
    @JsonProperty(JSON_PROPERTY_IS_ADMIN) Boolean isAdmin, 
    @JsonProperty(JSON_PROPERTY_IS_USER) Boolean isUser, 
    @JsonProperty(JSON_PROPERTY_ROLES) List<String> roles, 
    @JsonProperty(JSON_PROPERTY_UNIQUE_ID) String uniqueId, 
    @JsonProperty(JSON_PROPERTY_USER_NAME) String userName
  ) {
    this();
    this.isAdmin = isAdmin;
    this.isUser = isUser;
    this.roles = roles;
    this.uniqueId = uniqueId;
    this.userName = userName;
  }

  /**
   * true &#x3D; An administration user
   * @return isAdmin
   **/
  @NotNull
  @Schema(required = true, name = "true = An administration user")
  @JsonProperty(JSON_PROPERTY_IS_ADMIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getIsAdmin() {
    return isAdmin;
  }




  /**
   * true &#x3D; A standard user
   * @return isUser
   **/
  @NotNull
  @Schema(required = true, name = "true = A standard user")
  @JsonProperty(JSON_PROPERTY_IS_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getIsUser() {
    return isUser;
  }




  /**
   * Roles assigned to the user
   * @return roles
   **/
  @NotNull
  @Schema(required = true, name = "Roles assigned to the user")
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getRoles() {
    return roles;
  }




  /**
   * Unique ID for the user
   * @return uniqueId
   **/
  @NotNull
  @Schema(required = true, name = "Unique ID for the user")
  @JsonProperty(JSON_PROPERTY_UNIQUE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUniqueId() {
    return uniqueId;
  }




  public AuthUserCredentials userLimits(AuthLimits userLimits) {
    
    this.userLimits = userLimits;
    return this;
  }

  /**
   * Get userLimits
   * @return userLimits
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_USER_LIMITS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AuthLimits getUserLimits() {
    return userLimits;
  }


  @JsonProperty(JSON_PROPERTY_USER_LIMITS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserLimits(AuthLimits userLimits) {
    this.userLimits = userLimits;
  }


  /**
   * Name of the user
   * @return userName
   **/
  @NotNull
  @Schema(required = true, name = "Name of the user")
  @JsonProperty(JSON_PROPERTY_USER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUserName() {
    return userName;
  }




  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthUserCredentials authUserCredentials = (AuthUserCredentials) o;
    return Objects.equals(this.isAdmin, authUserCredentials.isAdmin) &&
        Objects.equals(this.isUser, authUserCredentials.isUser) &&
        Objects.equals(this.roles, authUserCredentials.roles) &&
        Objects.equals(this.uniqueId, authUserCredentials.uniqueId) &&
        Objects.equals(this.userLimits, authUserCredentials.userLimits) &&
        Objects.equals(this.userName, authUserCredentials.userName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isAdmin, isUser, roles, uniqueId, userLimits, userName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthUserCredentials {\n");
    sb.append("    isAdmin: ").append(toIndentedString(isAdmin)).append("\n");
    sb.append("    isUser: ").append(toIndentedString(isUser)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    uniqueId: ").append(toIndentedString(uniqueId)).append("\n");
    sb.append("    userLimits: ").append(toIndentedString(userLimits)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
