/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines the settings for the MS Office Bridge. The Office Bridge can be used as an alternative (to the built-in conversion) for converting Office documents. The Office Bridge requires a local installation of MS Office on the server and works only on Windows.
 */
@Schema(description = "Defines the settings for the MS Office Bridge. The Office Bridge can be used as an alternative (to the built-in conversion) for converting Office documents. The Office Bridge requires a local installation of MS Office on the server and works only on Windows.")
@JsonPropertyOrder({
  ApplicationConfigOfficeBridge.JSON_PROPERTY_ENABLED,
  ApplicationConfigOfficeBridge.JSON_PROPERTY_EXCEL,
  ApplicationConfigOfficeBridge.JSON_PROPERTY_POWER_POINT,
  ApplicationConfigOfficeBridge.JSON_PROPERTY_SHOW_MESSAGES_ON_DEBUG_VIEW,
  ApplicationConfigOfficeBridge.JSON_PROPERTY_USE_EXCEL,
  ApplicationConfigOfficeBridge.JSON_PROPERTY_USE_POWER_POINT,
  ApplicationConfigOfficeBridge.JSON_PROPERTY_USE_VISIO,
  ApplicationConfigOfficeBridge.JSON_PROPERTY_USE_WORD,
  ApplicationConfigOfficeBridge.JSON_PROPERTY_VISIO,
  ApplicationConfigOfficeBridge.JSON_PROPERTY_WORD
})
@JsonTypeName("ApplicationConfig_OfficeBridge")

public class ApplicationConfigOfficeBridge {
  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = false;

  public static final String JSON_PROPERTY_EXCEL = "excel";
  private ApplicationConfigOfficeBridgeApp excel;

  public static final String JSON_PROPERTY_POWER_POINT = "powerPoint";
  private ApplicationConfigOfficeBridgeApp powerPoint;

  public static final String JSON_PROPERTY_SHOW_MESSAGES_ON_DEBUG_VIEW = "showMessagesOnDebugView";
  private Boolean showMessagesOnDebugView = false;

  public static final String JSON_PROPERTY_USE_EXCEL = "useExcel";
  private Boolean useExcel = true;

  public static final String JSON_PROPERTY_USE_POWER_POINT = "usePowerPoint";
  private Boolean usePowerPoint = true;

  public static final String JSON_PROPERTY_USE_VISIO = "useVisio";
  private Boolean useVisio = false;

  public static final String JSON_PROPERTY_USE_WORD = "useWord";
  private Boolean useWord = true;

  public static final String JSON_PROPERTY_VISIO = "visio";
  private ApplicationConfigOfficeBridgeApp visio;

  public static final String JSON_PROPERTY_WORD = "word";
  private ApplicationConfigOfficeBridgeApp word;

  public ApplicationConfigOfficeBridge() {
  }

  public ApplicationConfigOfficeBridge enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

  /**
   * If enabled, then the MS Office bridge is activated.
   * @return enabled
   **/
  @Nullable
  @Schema(name = "If enabled, then the MS Office bridge is activated.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public ApplicationConfigOfficeBridge excel(ApplicationConfigOfficeBridgeApp excel) {
    
    this.excel = excel;
    return this;
  }

  /**
   * Get excel
   * @return excel
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_EXCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApplicationConfigOfficeBridgeApp getExcel() {
    return excel;
  }


  @JsonProperty(JSON_PROPERTY_EXCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExcel(ApplicationConfigOfficeBridgeApp excel) {
    this.excel = excel;
  }


  public ApplicationConfigOfficeBridge powerPoint(ApplicationConfigOfficeBridgeApp powerPoint) {
    
    this.powerPoint = powerPoint;
    return this;
  }

  /**
   * Get powerPoint
   * @return powerPoint
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_POWER_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApplicationConfigOfficeBridgeApp getPowerPoint() {
    return powerPoint;
  }


  @JsonProperty(JSON_PROPERTY_POWER_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPowerPoint(ApplicationConfigOfficeBridgeApp powerPoint) {
    this.powerPoint = powerPoint;
  }


  public ApplicationConfigOfficeBridge showMessagesOnDebugView(Boolean showMessagesOnDebugView) {
    
    this.showMessagesOnDebugView = showMessagesOnDebugView;
    return this;
  }

  /**
   * If enabled, then all debug messages of the Office Bridge will be visible in the Windows application [\&quot;SysInternals DebugView\&quot;](https://docs.microsoft.com/en-us/sysinternals/downloads/debugview)
   * @return showMessagesOnDebugView
   **/
  @Nullable
  @Schema(name = "If enabled, then all debug messages of the Office Bridge will be visible in the Windows application [\"SysInternals DebugView\"](https://docs.microsoft.com/en-us/sysinternals/downloads/debugview)")
  @JsonProperty(JSON_PROPERTY_SHOW_MESSAGES_ON_DEBUG_VIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowMessagesOnDebugView() {
    return showMessagesOnDebugView;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_MESSAGES_ON_DEBUG_VIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowMessagesOnDebugView(Boolean showMessagesOnDebugView) {
    this.showMessagesOnDebugView = showMessagesOnDebugView;
  }


  public ApplicationConfigOfficeBridge useExcel(Boolean useExcel) {
    
    this.useExcel = useExcel;
    return this;
  }

  /**
   * If enabled, then MS Excel is usable via the Office bridge.
   * @return useExcel
   **/
  @Nullable
  @Schema(name = "If enabled, then MS Excel is usable via the Office bridge.")
  @JsonProperty(JSON_PROPERTY_USE_EXCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseExcel() {
    return useExcel;
  }


  @JsonProperty(JSON_PROPERTY_USE_EXCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseExcel(Boolean useExcel) {
    this.useExcel = useExcel;
  }


  public ApplicationConfigOfficeBridge usePowerPoint(Boolean usePowerPoint) {
    
    this.usePowerPoint = usePowerPoint;
    return this;
  }

  /**
   * If enabled, then MS PowerPoint is usable via the Office bridge.
   * @return usePowerPoint
   **/
  @Nullable
  @Schema(name = "If enabled, then MS PowerPoint is usable via the Office bridge.")
  @JsonProperty(JSON_PROPERTY_USE_POWER_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUsePowerPoint() {
    return usePowerPoint;
  }


  @JsonProperty(JSON_PROPERTY_USE_POWER_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsePowerPoint(Boolean usePowerPoint) {
    this.usePowerPoint = usePowerPoint;
  }


  public ApplicationConfigOfficeBridge useVisio(Boolean useVisio) {
    
    this.useVisio = useVisio;
    return this;
  }

  /**
   * If enabled, then MS Visio is usable via the Office bridge.
   * @return useVisio
   **/
  @Nullable
  @Schema(name = "If enabled, then MS Visio is usable via the Office bridge.")
  @JsonProperty(JSON_PROPERTY_USE_VISIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseVisio() {
    return useVisio;
  }


  @JsonProperty(JSON_PROPERTY_USE_VISIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseVisio(Boolean useVisio) {
    this.useVisio = useVisio;
  }


  public ApplicationConfigOfficeBridge useWord(Boolean useWord) {
    
    this.useWord = useWord;
    return this;
  }

  /**
   * If enabled, then MS Word is usable via the Office bridge.
   * @return useWord
   **/
  @Nullable
  @Schema(name = "If enabled, then MS Word is usable via the Office bridge.")
  @JsonProperty(JSON_PROPERTY_USE_WORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseWord() {
    return useWord;
  }


  @JsonProperty(JSON_PROPERTY_USE_WORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseWord(Boolean useWord) {
    this.useWord = useWord;
  }


  public ApplicationConfigOfficeBridge visio(ApplicationConfigOfficeBridgeApp visio) {
    
    this.visio = visio;
    return this;
  }

  /**
   * Get visio
   * @return visio
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_VISIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApplicationConfigOfficeBridgeApp getVisio() {
    return visio;
  }


  @JsonProperty(JSON_PROPERTY_VISIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisio(ApplicationConfigOfficeBridgeApp visio) {
    this.visio = visio;
  }


  public ApplicationConfigOfficeBridge word(ApplicationConfigOfficeBridgeApp word) {
    
    this.word = word;
    return this;
  }

  /**
   * Get word
   * @return word
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_WORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApplicationConfigOfficeBridgeApp getWord() {
    return word;
  }


  @JsonProperty(JSON_PROPERTY_WORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWord(ApplicationConfigOfficeBridgeApp word) {
    this.word = word;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationConfigOfficeBridge applicationConfigOfficeBridge = (ApplicationConfigOfficeBridge) o;
    return Objects.equals(this.enabled, applicationConfigOfficeBridge.enabled) &&
        Objects.equals(this.excel, applicationConfigOfficeBridge.excel) &&
        Objects.equals(this.powerPoint, applicationConfigOfficeBridge.powerPoint) &&
        Objects.equals(this.showMessagesOnDebugView, applicationConfigOfficeBridge.showMessagesOnDebugView) &&
        Objects.equals(this.useExcel, applicationConfigOfficeBridge.useExcel) &&
        Objects.equals(this.usePowerPoint, applicationConfigOfficeBridge.usePowerPoint) &&
        Objects.equals(this.useVisio, applicationConfigOfficeBridge.useVisio) &&
        Objects.equals(this.useWord, applicationConfigOfficeBridge.useWord) &&
        Objects.equals(this.visio, applicationConfigOfficeBridge.visio) &&
        Objects.equals(this.word, applicationConfigOfficeBridge.word);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enabled, excel, powerPoint, showMessagesOnDebugView, useExcel, usePowerPoint, useVisio, useWord, visio, word);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationConfigOfficeBridge {\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    excel: ").append(toIndentedString(excel)).append("\n");
    sb.append("    powerPoint: ").append(toIndentedString(powerPoint)).append("\n");
    sb.append("    showMessagesOnDebugView: ").append(toIndentedString(showMessagesOnDebugView)).append("\n");
    sb.append("    useExcel: ").append(toIndentedString(useExcel)).append("\n");
    sb.append("    usePowerPoint: ").append(toIndentedString(usePowerPoint)).append("\n");
    sb.append("    useVisio: ").append(toIndentedString(useVisio)).append("\n");
    sb.append("    useWord: ").append(toIndentedString(useWord)).append("\n");
    sb.append("    visio: ").append(toIndentedString(visio)).append("\n");
    sb.append("    word: ").append(toIndentedString(word)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
