
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines a page transition for the full screen mode of the document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TransitionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TransitionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="objectKey" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="page" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="autoScroll" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="flyScale" type="{http://www.w3.org/2001/XMLSchema}float" default="1" />
 *       <attribute name="flyAreaOpaque" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="duration" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="style" type="{http://schema.webpdf.de/1.0/extraction/info}TransitionStyleType" default="none" />
 *       <attribute name="direction" type="{http://schema.webpdf.de/1.0/extraction/info}TransitionDirection" default="none" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TransitionType")
public class TransitionType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the transition definition.&#13;
     * &#13;
     *                         &lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "objectKey")
    protected String objectKey;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page a transition shall be defined for.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Whether or not the page is automatically flipped after a short period.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "autoScroll")
    protected Boolean autoScroll;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;For a fly animation, this determines the initial scale of the page, when flying in.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "flyScale")
    protected Float flyScale;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;For a fly animation, this determines whether or not the opacity shall stay constantly opaque during the animation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "flyAreaOpaque")
    protected Boolean flyAreaOpaque;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the duration in seconds, that the animation shall be played for.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "duration")
    protected Float duration;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The style of transition animation.&#13;
     *                         &lt;ul&gt;&lt;li&gt;blinds = Crossfades&lt;/li&gt;&lt;li&gt;box = Crossfades in a rectangular pattern&lt;/li&gt;&lt;li&gt;cover = Covers&lt;/li&gt;&lt;li&gt;dissolve = Dissolves&lt;/li&gt;&lt;li&gt;fade = Fades&lt;/li&gt;&lt;li&gt;fly = Page flies in&lt;/li&gt;&lt;li&gt;glitter = Page dissolves and is replaced&lt;/li&gt;&lt;li&gt;push = Page is pushed out&lt;/li&gt;&lt;li&gt;split = Splits page&lt;/li&gt;&lt;li&gt;uncover = Uncovers page&lt;/li&gt;&lt;li&gt;wipe = Wipes page&lt;/li&gt;&lt;li&gt;none = No special effect&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "style")
    protected TransitionStyleType style;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The direction of the transition animation (provided that it can be applied to the animation).&#13;
     *                         &lt;ul&gt;&lt;li&gt;leftToRight = From left to right&lt;/li&gt;&lt;li&gt;bottomToTop = From bottom to top&lt;/li&gt;&lt;li&gt;rightToLeft = From right to left&lt;/li&gt;&lt;li&gt;topToBottom = From top to bottom&lt;/li&gt;&lt;li&gt;topLeftToBottomRight = From top left to bottom right&lt;/li&gt;&lt;li&gt;none = Use the default value for the animation&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "direction")
    protected TransitionDirection direction;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the transition definition.&#13;
     * &#13;
     *                         &lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getObjectKey() {
        if (objectKey == null) {
            return "";
        } else {
            return objectKey;
        }
    }

    /**
     * Sets the value of the objectKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getObjectKey()
     */
    public void setObjectKey(String value) {
        this.objectKey = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page a transition shall be defined for.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  0;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(Integer value) {
        this.page = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Whether or not the page is automatically flipped after a short period.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isAutoScroll() {
        if (autoScroll == null) {
            return false;
        } else {
            return autoScroll;
        }
    }

    /**
     * Sets the value of the autoScroll property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isAutoScroll()
     */
    public void setAutoScroll(Boolean value) {
        this.autoScroll = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;For a fly animation, this determines the initial scale of the page, when flying in.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getFlyScale() {
        if (flyScale == null) {
            return  1.0F;
        } else {
            return flyScale;
        }
    }

    /**
     * Sets the value of the flyScale property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getFlyScale()
     */
    public void setFlyScale(Float value) {
        this.flyScale = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;For a fly animation, this determines whether or not the opacity shall stay constantly opaque during the animation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFlyAreaOpaque() {
        if (flyAreaOpaque == null) {
            return false;
        } else {
            return flyAreaOpaque;
        }
    }

    /**
     * Sets the value of the flyAreaOpaque property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isFlyAreaOpaque()
     */
    public void setFlyAreaOpaque(Boolean value) {
        this.flyAreaOpaque = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the duration in seconds, that the animation shall be played for.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getDuration() {
        if (duration == null) {
            return  1.0F;
        } else {
            return duration;
        }
    }

    /**
     * Sets the value of the duration property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getDuration()
     */
    public void setDuration(Float value) {
        this.duration = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The style of transition animation.&#13;
     *                         &lt;ul&gt;&lt;li&gt;blinds = Crossfades&lt;/li&gt;&lt;li&gt;box = Crossfades in a rectangular pattern&lt;/li&gt;&lt;li&gt;cover = Covers&lt;/li&gt;&lt;li&gt;dissolve = Dissolves&lt;/li&gt;&lt;li&gt;fade = Fades&lt;/li&gt;&lt;li&gt;fly = Page flies in&lt;/li&gt;&lt;li&gt;glitter = Page dissolves and is replaced&lt;/li&gt;&lt;li&gt;push = Page is pushed out&lt;/li&gt;&lt;li&gt;split = Splits page&lt;/li&gt;&lt;li&gt;uncover = Uncovers page&lt;/li&gt;&lt;li&gt;wipe = Wipes page&lt;/li&gt;&lt;li&gt;none = No special effect&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TransitionStyleType }
     *     
     */
    public TransitionStyleType getStyle() {
        if (style == null) {
            return TransitionStyleType.NONE;
        } else {
            return style;
        }
    }

    /**
     * Sets the value of the style property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransitionStyleType }
     *     
     * @see #getStyle()
     */
    public void setStyle(TransitionStyleType value) {
        this.style = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The direction of the transition animation (provided that it can be applied to the animation).&#13;
     *                         &lt;ul&gt;&lt;li&gt;leftToRight = From left to right&lt;/li&gt;&lt;li&gt;bottomToTop = From bottom to top&lt;/li&gt;&lt;li&gt;rightToLeft = From right to left&lt;/li&gt;&lt;li&gt;topToBottom = From top to bottom&lt;/li&gt;&lt;li&gt;topLeftToBottomRight = From top left to bottom right&lt;/li&gt;&lt;li&gt;none = Use the default value for the animation&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TransitionDirection }
     *     
     */
    public TransitionDirection getDirection() {
        if (direction == null) {
            return TransitionDirection.NONE;
        } else {
            return direction;
        }
    }

    /**
     * Sets the value of the direction property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransitionDirection }
     *     
     * @see #getDirection()
     */
    public void setDirection(TransitionDirection value) {
        this.direction = value;
    }

}
