
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the predominant document's text writing/reading direction.&#13;
 *                     &lt;ul&gt;&lt;li&gt;leftToRight or&lt;/li&gt;&lt;li&gt;rightToLeft&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TextDirectionType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="TextDirectionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="leftToRight"/>
 *     <enumeration value="rightToLeft"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TextDirectionType")
@XmlEnum
public enum TextDirectionType {

    @XmlEnumValue("leftToRight")
    LEFT_TO_RIGHT("leftToRight"),
    @XmlEnumValue("rightToLeft")
    RIGHT_TO_LEFT("rightToLeft");
    private final String value;

    TextDirectionType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static TextDirectionType fromValue(String v) {
        for (TextDirectionType c: TextDirectionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
