
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines an image resource of a PDF document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ImageType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ImageType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="objectKey" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="width" type="{http://www.w3.org/2001/XMLSchema}int" default="0" />
 *       <attribute name="height" type="{http://www.w3.org/2001/XMLSchema}int" default="0" />
 *       <attribute name="suffix" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="page" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="bitsPerComponent" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ImageType")
public class ImageType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the image resource definition.&#13;
     * &#13;
     *                         &lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "objectKey")
    protected String objectKey;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The width of the image in points.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "width")
    protected Integer width;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The height of the image in points.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "height")
    protected Integer height;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Returns the file type suffix of the image. (This suffix depends on the used image encoding and therefore is highly reliable.)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "suffix")
    protected String suffix;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of the page containing the image resource.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of bits used to encode one color component.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "bitsPerComponent")
    protected Integer bitsPerComponent;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the image resource definition.&#13;
     * &#13;
     *                         &lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getObjectKey() {
        if (objectKey == null) {
            return "";
        } else {
            return objectKey;
        }
    }

    /**
     * Sets the value of the objectKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getObjectKey()
     */
    public void setObjectKey(String value) {
        this.objectKey = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The width of the image in points.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getWidth() {
        if (width == null) {
            return  0;
        } else {
            return width;
        }
    }

    /**
     * Sets the value of the width property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getWidth()
     */
    public void setWidth(Integer value) {
        this.width = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The height of the image in points.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getHeight() {
        if (height == null) {
            return  0;
        } else {
            return height;
        }
    }

    /**
     * Sets the value of the height property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getHeight()
     */
    public void setHeight(Integer value) {
        this.height = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Returns the file type suffix of the image. (This suffix depends on the used image encoding and therefore is highly reliable.)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSuffix() {
        if (suffix == null) {
            return "";
        } else {
            return suffix;
        }
    }

    /**
     * Sets the value of the suffix property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSuffix()
     */
    public void setSuffix(String value) {
        this.suffix = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of the page containing the image resource.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  0;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(Integer value) {
        this.page = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of bits used to encode one color component.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getBitsPerComponent() {
        if (bitsPerComponent == null) {
            return  0;
        } else {
            return bitsPerComponent;
        }
    }

    /**
     * Sets the value of the bitsPerComponent property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getBitsPerComponent()
     */
    public void setBitsPerComponent(Integer value) {
        this.bitsPerComponent = value;
    }

}
