
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the draw style of an drawable shape.&#13;
 *                     &lt;ul&gt;&lt;li&gt;fill = fill the shape&lt;/li&gt;&lt;li&gt;stroke = draw the outlines of the shape&lt;/li&gt;&lt;li&gt;fillAndStroke = draw the outlines and fill the shape&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for DrawModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="DrawModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="fill"/>
 *     <enumeration value="stroke"/>
 *     <enumeration value="fillAndStroke"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "DrawModeType")
@XmlEnum
public enum DrawModeType {

    @XmlEnumValue("fill")
    FILL("fill"),
    @XmlEnumValue("stroke")
    STROKE("stroke"),
    @XmlEnumValue("fillAndStroke")
    FILL_AND_STROKE("fillAndStroke");
    private final String value;

    DrawModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static DrawModeType fromValue(String v) {
        for (DrawModeType c: DrawModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
