
package net.webpdf.parameter.schema.extraction.info;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The document's description contains a number of metadata attributes, that further describe the author, creation, contents etc of the document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for DescriptionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="DescriptionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="author" type="{http://schema.webpdf.de/1.0/extraction/info}AuthorType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="keywords" type="{http://schema.webpdf.de/1.0/extraction/info}KeywordType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="custom" type="{http://schema.webpdf.de/1.0/extraction/info}CustomDescriptionType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="title" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="subject" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="creator" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="producer" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="application" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="creationDate" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="modificationDate" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DescriptionType", propOrder = {
    "author",
    "keywords",
    "custom"
})
public class DescriptionType {

    protected List<AuthorType> author;
    protected List<KeywordType> keywords;
    protected List<CustomDescriptionType> custom;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The document's title.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "title")
    protected String title;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The document's subject.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "subject")
    protected String subject;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If the document has been converted to a PDF from another format, this is the name of the application, that created the original document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "creator")
    protected String creator;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If the document has been converted to a PDF from another format, this is the name of the application, that converted it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "producer")
    protected String producer;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The application used to create the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "application")
    protected String application;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The date of the document's creation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "creationDate")
    protected String creationDate;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The date of the most recent modification of the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "modificationDate")
    protected String modificationDate;

    /**
     * Gets the value of the author property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the author property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAuthor().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AuthorType }
     * </p>
     * 
     * 
     * @return
     *     The value of the author property.
     */
    public List<AuthorType> getAuthor() {
        if (author == null) {
            author = new ArrayList<>();
        }
        return this.author;
    }

    /**
     * Gets the value of the keywords property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the keywords property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getKeywords().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link KeywordType }
     * </p>
     * 
     * 
     * @return
     *     The value of the keywords property.
     */
    public List<KeywordType> getKeywords() {
        if (keywords == null) {
            keywords = new ArrayList<>();
        }
        return this.keywords;
    }

    /**
     * Gets the value of the custom property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the custom property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCustom().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CustomDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the custom property.
     */
    public List<CustomDescriptionType> getCustom() {
        if (custom == null) {
            custom = new ArrayList<>();
        }
        return this.custom;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The document's title.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTitle() {
        if (title == null) {
            return "";
        } else {
            return title;
        }
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getTitle()
     */
    public void setTitle(String value) {
        this.title = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The document's subject.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubject() {
        if (subject == null) {
            return "";
        } else {
            return subject;
        }
    }

    /**
     * Sets the value of the subject property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSubject()
     */
    public void setSubject(String value) {
        this.subject = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If the document has been converted to a PDF from another format, this is the name of the application, that created the original document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCreator() {
        if (creator == null) {
            return "";
        } else {
            return creator;
        }
    }

    /**
     * Sets the value of the creator property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCreator()
     */
    public void setCreator(String value) {
        this.creator = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If the document has been converted to a PDF from another format, this is the name of the application, that converted it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProducer() {
        if (producer == null) {
            return "";
        } else {
            return producer;
        }
    }

    /**
     * Sets the value of the producer property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getProducer()
     */
    public void setProducer(String value) {
        this.producer = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The application used to create the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getApplication() {
        if (application == null) {
            return "";
        } else {
            return application;
        }
    }

    /**
     * Sets the value of the application property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getApplication()
     */
    public void setApplication(String value) {
        this.application = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The date of the document's creation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCreationDate() {
        if (creationDate == null) {
            return "";
        } else {
            return creationDate;
        }
    }

    /**
     * Sets the value of the creationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCreationDate()
     */
    public void setCreationDate(String value) {
        this.creationDate = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The date of the most recent modification of the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModificationDate() {
        if (modificationDate == null) {
            return "";
        } else {
            return modificationDate;
        }
    }

    /**
     * Sets the value of the modificationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getModificationDate()
     */
    public void setModificationDate(String value) {
        this.modificationDate = value;
    }

}
