
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects a border style for a drawn shape's outline.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BorderStyle complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BorderStyle">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="style" type="{http://www.w3.org/2001/XMLSchema}string" default="S" />
 *       <attribute name="width" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="dashPattern" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="dashPhase" type="{http://www.w3.org/2001/XMLSchema}int" default="0" />
 *       <attribute name="effectStyle" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="effectIntensity" type="{http://www.w3.org/2001/XMLSchema}float" default="0" />
 *       <attribute name="interiorColor" type="{http://schema.webpdf.de/1.0/extraction/info}RgbColorType" default="#4800FF" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BorderStyle")
public class BorderStyle {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The style of the shapes border.&#13;
     *                         &lt;ul&gt;&lt;li&gt;S = Solid&lt;/li&gt;&lt;li&gt;D = Dashed&lt;/li&gt;&lt;li&gt;B = Beveled&lt;/li&gt;&lt;li&gt;I = Inset&lt;/li&gt;&lt;li&gt;U = Underline&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         Further custom styles may be contained and shall default to a solid border if unknown.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "style")
    protected String style;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The border width/line thickness in points.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "width")
    protected Float width;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The dash pattern (array) of a dashed border. The dash array contains the unit lengths of alternating dashes and gaps, that shall be cycled through along the length of the border.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "dashPattern")
    protected String dashPattern;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The phase of the dash pattern.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "dashPhase")
    protected Integer dashPhase;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The border effect to apply to the border shape.&#13;
     *                         &lt;ul&gt;&lt;li&gt;S = Apply no border effects.&lt;/li&gt;&lt;li&gt;C = Apply a cloud pattern to the border shape.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "effectStyle")
    protected String effectStyle;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The intensity of a possibly set cloud effect, in a range from 0 to 2.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "effectIntensity")
    protected Float effectIntensity;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The interior (fill) color for the shape.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "interiorColor")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String interiorColor;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The style of the shapes border.&#13;
     *                         &lt;ul&gt;&lt;li&gt;S = Solid&lt;/li&gt;&lt;li&gt;D = Dashed&lt;/li&gt;&lt;li&gt;B = Beveled&lt;/li&gt;&lt;li&gt;I = Inset&lt;/li&gt;&lt;li&gt;U = Underline&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         Further custom styles may be contained and shall default to a solid border if unknown.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStyle() {
        if (style == null) {
            return "S";
        } else {
            return style;
        }
    }

    /**
     * Sets the value of the style property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getStyle()
     */
    public void setStyle(String value) {
        this.style = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The border width/line thickness in points.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getWidth() {
        if (width == null) {
            return  1.0F;
        } else {
            return width;
        }
    }

    /**
     * Sets the value of the width property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getWidth()
     */
    public void setWidth(Float value) {
        this.width = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The dash pattern (array) of a dashed border. The dash array contains the unit lengths of alternating dashes and gaps, that shall be cycled through along the length of the border.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDashPattern() {
        if (dashPattern == null) {
            return "";
        } else {
            return dashPattern;
        }
    }

    /**
     * Sets the value of the dashPattern property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDashPattern()
     */
    public void setDashPattern(String value) {
        this.dashPattern = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The phase of the dash pattern.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDashPhase() {
        if (dashPhase == null) {
            return  0;
        } else {
            return dashPhase;
        }
    }

    /**
     * Sets the value of the dashPhase property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getDashPhase()
     */
    public void setDashPhase(Integer value) {
        this.dashPhase = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The border effect to apply to the border shape.&#13;
     *                         &lt;ul&gt;&lt;li&gt;S = Apply no border effects.&lt;/li&gt;&lt;li&gt;C = Apply a cloud pattern to the border shape.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEffectStyle() {
        if (effectStyle == null) {
            return "";
        } else {
            return effectStyle;
        }
    }

    /**
     * Sets the value of the effectStyle property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getEffectStyle()
     */
    public void setEffectStyle(String value) {
        this.effectStyle = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The intensity of a possibly set cloud effect, in a range from 0 to 2.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getEffectIntensity() {
        if (effectIntensity == null) {
            return  0.0F;
        } else {
            return effectIntensity;
        }
    }

    /**
     * Sets the value of the effectIntensity property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getEffectIntensity()
     */
    public void setEffectIntensity(Float value) {
        this.effectIntensity = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The interior (fill) color for the shape.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInteriorColor() {
        if (interiorColor == null) {
            return "#4800FF";
        } else {
            return interiorColor;
        }
    }

    /**
     * Sets the value of the interiorColor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getInteriorColor()
     */
    public void setInteriorColor(String value) {
        this.interiorColor = value;
    }

}
