
package net.webpdf.parameter.schema.extraction.barcode;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 * <p>Java class for BarcodeEncodingsType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="BarcodeEncodingsType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="aztec"/>
 *     <enumeration value="codabar"/>
 *     <enumeration value="code128"/>
 *     <enumeration value="code39"/>
 *     <enumeration value="code93"/>
 *     <enumeration value="datamatrix"/>
 *     <enumeration value="ean13"/>
 *     <enumeration value="ean8"/>
 *     <enumeration value="itf"/>
 *     <enumeration value="maxicode"/>
 *     <enumeration value="pdf417"/>
 *     <enumeration value="qrcode"/>
 *     <enumeration value="rssexpanded"/>
 *     <enumeration value="upca"/>
 *     <enumeration value="upce"/>
 *     <enumeration value="upceanextension"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "BarcodeEncodingsType")
@XmlEnum
public enum BarcodeEncodingsType {

    @XmlEnumValue("aztec")
    AZTEC("aztec"),
    @XmlEnumValue("codabar")
    CODABAR("codabar"),
    @XmlEnumValue("code128")
    CODE_128("code128"),
    @XmlEnumValue("code39")
    CODE_39("code39"),
    @XmlEnumValue("code93")
    CODE_93("code93"),
    @XmlEnumValue("datamatrix")
    DATAMATRIX("datamatrix"),
    @XmlEnumValue("ean13")
    EAN_13("ean13"),
    @XmlEnumValue("ean8")
    EAN_8("ean8"),
    @XmlEnumValue("itf")
    ITF("itf"),
    @XmlEnumValue("maxicode")
    MAXICODE("maxicode"),
    @XmlEnumValue("pdf417")
    PDF_417("pdf417"),
    @XmlEnumValue("qrcode")
    QRCODE("qrcode"),
    @XmlEnumValue("rssexpanded")
    RSSEXPANDED("rssexpanded"),
    @XmlEnumValue("upca")
    UPCA("upca"),
    @XmlEnumValue("upce")
    UPCE("upce"),
    @XmlEnumValue("upceanextension")
    UPCEANEXTENSION("upceanextension");
    private final String value;

    BarcodeEncodingsType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static BarcodeEncodingsType fromValue(String v) {
        for (BarcodeEncodingsType c: BarcodeEncodingsType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
