/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.webservice;

import javax.xml.transform.stream.StreamSource;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.openapi.OperationBarcode;
import net.webpdf.wsclient.openapi.OperationBarcodeOperation;
import net.webpdf.wsclient.openapi.OperationConverter;
import net.webpdf.wsclient.openapi.OperationConverterOperation;
import net.webpdf.wsclient.openapi.OperationOcr;
import net.webpdf.wsclient.openapi.OperationOcrOperation;
import net.webpdf.wsclient.openapi.OperationPdfa;
import net.webpdf.wsclient.openapi.OperationPdfaOperation;
import net.webpdf.wsclient.openapi.OperationSignature;
import net.webpdf.wsclient.openapi.OperationSignatureOperation;
import net.webpdf.wsclient.openapi.OperationToolboxOperation;
import net.webpdf.wsclient.openapi.OperationUrlConverter;
import net.webpdf.wsclient.openapi.OperationUrlConverterOperation;
import net.webpdf.wsclient.openapi.RestOperationData;
import net.webpdf.wsclient.schema.operation.BarcodeType;
import net.webpdf.wsclient.schema.operation.ConverterType;
import net.webpdf.wsclient.schema.operation.OcrType;
import net.webpdf.wsclient.schema.operation.OperationData;
import net.webpdf.wsclient.schema.operation.PdfaType;
import net.webpdf.wsclient.schema.operation.SignatureType;
import net.webpdf.wsclient.schema.operation.UrlConverterType;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.session.documents.Document;
import net.webpdf.wsclient.session.rest.RestSession;
import net.webpdf.wsclient.session.rest.documents.RestDocument;
import net.webpdf.wsclient.session.soap.SoapSession;
import net.webpdf.wsclient.session.soap.documents.SoapDocument;
import net.webpdf.wsclient.tools.SerializeHelper;
import net.webpdf.wsclient.webservice.WebService;
import net.webpdf.wsclient.webservice.WebServiceType;
import net.webpdf.wsclient.webservice.rest.BarcodeRestWebService;
import net.webpdf.wsclient.webservice.rest.ConverterRestWebService;
import net.webpdf.wsclient.webservice.rest.OcrRestWebService;
import net.webpdf.wsclient.webservice.rest.PdfaRestWebService;
import net.webpdf.wsclient.webservice.rest.RestWebService;
import net.webpdf.wsclient.webservice.rest.SignatureRestWebService;
import net.webpdf.wsclient.webservice.rest.ToolboxRestWebService;
import net.webpdf.wsclient.webservice.rest.UrlConverterRestWebService;
import net.webpdf.wsclient.webservice.soap.BarcodeWebService;
import net.webpdf.wsclient.webservice.soap.ConverterWebService;
import net.webpdf.wsclient.webservice.soap.OcrWebService;
import net.webpdf.wsclient.webservice.soap.PdfaWebService;
import net.webpdf.wsclient.webservice.soap.SignatureWebService;
import net.webpdf.wsclient.webservice.soap.ToolboxWebService;
import net.webpdf.wsclient.webservice.soap.UrlConverterWebService;
import org.jetbrains.annotations.NotNull;

public final class WebServiceFactory {
    private WebServiceFactory() {
    }

    @NotNull
    public static <T_DOCUMENT extends Document, T_WEBSERVICE extends WebService<?, ?, T_DOCUMENT, ?, ?, ?>> T_WEBSERVICE createInstance(@NotNull Session session, @NotNull WebServiceType webServiceType) throws ResultException {
        switch (session.getWebServiceProtocol()) {
            case SOAP: {
                if (session instanceof SoapSession) {
                    return WebServiceFactory.createSoapInstance((SoapSession)session, webServiceType, WebServiceFactory.createSoapParameters(webServiceType));
                }
                throw new ClientResultException(Error.INVALID_WEBSERVICE_SESSION);
            }
            case REST: {
                if (session instanceof RestSession) {
                    return WebServiceFactory.createRestInstance((RestSession)session, webServiceType, WebServiceFactory.createRestParameters(webServiceType));
                }
                throw new ClientResultException(Error.INVALID_WEBSERVICE_SESSION);
            }
        }
        throw new ClientResultException(Error.UNKNOWN_WEBSERVICE_PROTOCOL);
    }

    @NotNull
    private static OperationData createSoapParameters(@NotNull WebServiceType webServiceType) throws ResultException {
        OperationData operationData = new OperationData();
        switch (webServiceType) {
            case CONVERTER: {
                operationData.setConverter(new ConverterType());
                break;
            }
            case URLCONVERTER: {
                operationData.setUrlconverter(new UrlConverterType());
                break;
            }
            case PDFA: {
                operationData.setPdfa(new PdfaType());
                break;
            }
            case TOOLBOX: {
                break;
            }
            case OCR: {
                operationData.setOcr(new OcrType());
                break;
            }
            case SIGNATURE: {
                operationData.setSignature(new SignatureType());
                break;
            }
            case BARCODE: {
                operationData.setBarcode(new BarcodeType());
                break;
            }
            default: {
                throw new ClientResultException(Error.UNKNOWN_WEBSERVICE_TYPE);
            }
        }
        return operationData;
    }

    @NotNull
    private static RestOperationData createRestParameters(@NotNull WebServiceType webServiceType) throws ResultException {
        RestOperationData operation;
        switch (webServiceType) {
            case CONVERTER: {
                OperationConverterOperation converterOperation = new OperationConverterOperation();
                converterOperation.setConverter(new OperationConverter());
                operation = new RestOperationData(converterOperation);
                break;
            }
            case URLCONVERTER: {
                OperationUrlConverterOperation urlConverterOperation = new OperationUrlConverterOperation();
                urlConverterOperation.setUrlconverter(new OperationUrlConverter());
                operation = new RestOperationData(urlConverterOperation);
                break;
            }
            case PDFA: {
                OperationPdfaOperation pdfaOperation = new OperationPdfaOperation();
                pdfaOperation.setPdfa(new OperationPdfa());
                operation = new RestOperationData(pdfaOperation);
                break;
            }
            case TOOLBOX: {
                operation = new RestOperationData(new OperationToolboxOperation());
                break;
            }
            case OCR: {
                OperationOcrOperation ocrOperation = new OperationOcrOperation();
                ocrOperation.setOcr(new OperationOcr());
                operation = new RestOperationData(ocrOperation);
                break;
            }
            case SIGNATURE: {
                OperationSignatureOperation signatureOperation = new OperationSignatureOperation();
                signatureOperation.setSignature(new OperationSignature());
                operation = new RestOperationData(signatureOperation);
                break;
            }
            case BARCODE: {
                OperationBarcodeOperation barcodeOperation = new OperationBarcodeOperation();
                barcodeOperation.setBarcode(new OperationBarcode());
                operation = new RestOperationData(barcodeOperation);
                break;
            }
            default: {
                throw new ClientResultException(Error.UNKNOWN_WEBSERVICE_TYPE);
            }
        }
        return operation;
    }

    @NotNull
    public static <T_DOCUMENT extends Document, T_WEBSERVICE extends WebService<?, ?, T_DOCUMENT, ?, ?, ?>> T_WEBSERVICE createInstance(@NotNull Session session, @NotNull StreamSource streamSource) throws ResultException {
        switch (session.getWebServiceProtocol()) {
            case SOAP: {
                OperationData soapOperationData = SerializeHelper.fromXML(streamSource, OperationData.class);
                if (session instanceof SoapSession) {
                    return WebServiceFactory.createSoapInstance((SoapSession)session, WebServiceFactory.determineWebServiceType(soapOperationData), soapOperationData);
                }
                throw new ClientResultException(Error.INVALID_WEBSERVICE_SESSION);
            }
            case REST: {
                RestOperationData restOperationData = SerializeHelper.fromJSON(streamSource, RestOperationData.class);
                if (session instanceof RestSession) {
                    return WebServiceFactory.createRestInstance((RestSession)session, WebServiceFactory.determineWebServiceType(restOperationData), restOperationData);
                }
                throw new ClientResultException(Error.INVALID_WEBSERVICE_SESSION);
            }
        }
        throw new ClientResultException(Error.UNKNOWN_WEBSERVICE_PROTOCOL);
    }

    @NotNull
    private static WebServiceType determineWebServiceType(@NotNull Object operationData) throws ResultException {
        if (operationData instanceof OperationData && ((OperationData)operationData).isSetConverter() || operationData instanceof RestOperationData && ((RestOperationData)operationData).isSetConverter()) {
            return WebServiceType.CONVERTER;
        }
        if (operationData instanceof OperationData && ((OperationData)operationData).isSetBarcode() || operationData instanceof RestOperationData && ((RestOperationData)operationData).isSetBarcode()) {
            return WebServiceType.BARCODE;
        }
        if (operationData instanceof OperationData && ((OperationData)operationData).isSetOcr() || operationData instanceof RestOperationData && ((RestOperationData)operationData).isSetOcr()) {
            return WebServiceType.OCR;
        }
        if (operationData instanceof OperationData && ((OperationData)operationData).isSetPdfa() || operationData instanceof RestOperationData && ((RestOperationData)operationData).isSetPdfa()) {
            return WebServiceType.PDFA;
        }
        if (operationData instanceof OperationData && ((OperationData)operationData).isSetSignature() || operationData instanceof RestOperationData && ((RestOperationData)operationData).isSetSignature()) {
            return WebServiceType.SIGNATURE;
        }
        if (operationData instanceof OperationData && ((OperationData)operationData).isSetToolbox() || operationData instanceof RestOperationData && ((RestOperationData)operationData).isSetToolbox()) {
            return WebServiceType.TOOLBOX;
        }
        if (operationData instanceof OperationData && ((OperationData)operationData).isSetUrlconverter() || operationData instanceof RestOperationData && ((RestOperationData)operationData).isSetUrlconverter()) {
            return WebServiceType.URLCONVERTER;
        }
        throw new ClientResultException(Error.UNKNOWN_WEBSERVICE_TYPE);
    }

    @NotNull
    private static <T_DOCUMENT extends SoapDocument, T_WEBSERVICE extends WebService<?, ?, T_DOCUMENT, ?, ?, ?>> T_WEBSERVICE createSoapInstance(@NotNull SoapSession<T_DOCUMENT> session, @NotNull WebServiceType webServiceType, @NotNull OperationData operationData) throws ResultException {
        switch (webServiceType) {
            case CONVERTER: {
                ConverterWebService<T_DOCUMENT> converterWebService = new ConverterWebService<T_DOCUMENT>(session);
                converterWebService.setOperationParameters(operationData.getConverter());
                return (T_WEBSERVICE)converterWebService;
            }
            case SIGNATURE: {
                SignatureWebService<T_DOCUMENT> signatureWebService = new SignatureWebService<T_DOCUMENT>(session);
                signatureWebService.setOperationParameters(operationData.getSignature());
                return (T_WEBSERVICE)signatureWebService;
            }
            case PDFA: {
                PdfaWebService<T_DOCUMENT> pdfaWebService = new PdfaWebService<T_DOCUMENT>(session);
                pdfaWebService.setOperationParameters(operationData.getPdfa());
                return (T_WEBSERVICE)pdfaWebService;
            }
            case OCR: {
                OcrWebService<T_DOCUMENT> ocrWebService = new OcrWebService<T_DOCUMENT>(session);
                ocrWebService.setOperationParameters(operationData.getOcr());
                return (T_WEBSERVICE)ocrWebService;
            }
            case TOOLBOX: {
                ToolboxWebService<T_DOCUMENT> toolboxWebService = new ToolboxWebService<T_DOCUMENT>(session);
                toolboxWebService.setOperationParameters(operationData.getToolbox());
                return (T_WEBSERVICE)toolboxWebService;
            }
            case URLCONVERTER: {
                UrlConverterWebService<T_DOCUMENT> urlConverterWebService = new UrlConverterWebService<T_DOCUMENT>(session);
                urlConverterWebService.setOperationParameters(operationData.getUrlconverter());
                return (T_WEBSERVICE)urlConverterWebService;
            }
            case BARCODE: {
                BarcodeWebService<T_DOCUMENT> barcodeWebService = new BarcodeWebService<T_DOCUMENT>(session);
                barcodeWebService.setOperationParameters(operationData.getBarcode());
                return (T_WEBSERVICE)barcodeWebService;
            }
        }
        throw new ClientResultException(Error.UNKNOWN_WEBSERVICE_TYPE);
    }

    @NotNull
    private static <T_DOCUMENT extends RestDocument, T_WEBSERVICE extends RestWebService<?, ?, T_DOCUMENT>> T_WEBSERVICE createRestInstance(@NotNull RestSession<T_DOCUMENT> session, @NotNull WebServiceType webServiceType, @NotNull RestOperationData operationData) throws ResultException {
        switch (webServiceType) {
            case CONVERTER: {
                ConverterRestWebService<T_DOCUMENT> converterWebService = new ConverterRestWebService<T_DOCUMENT>(session);
                converterWebService.setOperationParameters(operationData.getConverter());
                return (T_WEBSERVICE)converterWebService;
            }
            case SIGNATURE: {
                SignatureRestWebService<T_DOCUMENT> signatureWebService = new SignatureRestWebService<T_DOCUMENT>(session);
                signatureWebService.setOperationParameters(operationData.getSignature());
                return (T_WEBSERVICE)signatureWebService;
            }
            case PDFA: {
                PdfaRestWebService<T_DOCUMENT> pdfaWebService = new PdfaRestWebService<T_DOCUMENT>(session);
                pdfaWebService.setOperationParameters(operationData.getPdfa());
                return (T_WEBSERVICE)pdfaWebService;
            }
            case OCR: {
                OcrRestWebService<T_DOCUMENT> ocrWebService = new OcrRestWebService<T_DOCUMENT>(session);
                ocrWebService.setOperationParameters(operationData.getOcr());
                return (T_WEBSERVICE)ocrWebService;
            }
            case TOOLBOX: {
                ToolboxRestWebService<T_DOCUMENT> toolboxWebService = new ToolboxRestWebService<T_DOCUMENT>(session);
                toolboxWebService.setOperationParameters(operationData.getToolbox());
                return (T_WEBSERVICE)toolboxWebService;
            }
            case URLCONVERTER: {
                UrlConverterRestWebService<T_DOCUMENT> urlConverterWebService = new UrlConverterRestWebService<T_DOCUMENT>(session);
                urlConverterWebService.setOperationParameters(operationData.getUrlconverter());
                return (T_WEBSERVICE)urlConverterWebService;
            }
            case BARCODE: {
                BarcodeRestWebService<T_DOCUMENT> barcodeWebService = new BarcodeRestWebService<T_DOCUMENT>(session);
                barcodeWebService.setOperationParameters(operationData.getBarcode());
                return (T_WEBSERVICE)barcodeWebService;
            }
        }
        throw new ClientResultException(Error.UNKNOWN_WEBSERVICE_TYPE);
    }
}

