/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.soap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.HttpHost;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientProxySelector
extends ProxySelector
implements AutoCloseable {
    @NotNull
    private static final String[] SUPPORTED_SCHEMES = new String[]{"http", "https"};
    @NotNull
    private final Map<SocketAddress, Proxy> proxies = new HashMap<SocketAddress, Proxy>();
    @NotNull
    private final List<URI> routedResources;
    @Nullable
    private final ProxySelector defaultProxySelector;

    public ClientProxySelector(@NotNull URI[] routedResources, HttpHost ... proxies) {
        this.routedResources = Arrays.asList(routedResources);
        this.defaultProxySelector = ProxySelector.getDefault();
        ProxySelector.setDefault(this);
        for (HttpHost proxy : proxies) {
            this.addProxy(proxy);
        }
    }

    public void addProxy(@NotNull HttpHost proxy) {
        if (this.isSupportedScheme(proxy.getSchemeName())) {
            InetSocketAddress socketAddress = new InetSocketAddress(proxy.getHostName(), proxy.getPort());
            Proxy resolvedProxy = new Proxy(Proxy.Type.HTTP, socketAddress);
            this.proxies.put(socketAddress, resolvedProxy);
        }
    }

    public void addRoutedResource(URI routedResource) {
        this.routedResources.add(routedResource);
    }

    @Override
    @NotNull
    public List<Proxy> select(@Nullable URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        if (this.isRoutedURI(uri)) {
            return new ArrayList<Proxy>(this.proxies.values());
        }
        if (this.defaultProxySelector != null) {
            return this.defaultProxySelector.select(uri);
        }
        return Collections.singletonList(Proxy.NO_PROXY);
    }

    @Override
    public void connectFailed(@Nullable URI uri, @Nullable SocketAddress socketAddress, @Nullable IOException exception) {
        if (uri == null || socketAddress == null || exception == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
        if (this.proxies.get(socketAddress) == null && this.defaultProxySelector != null) {
            this.defaultProxySelector.connectFailed(uri, socketAddress, exception);
        }
    }

    @Override
    public void close() {
        ProxySelector.setDefault(this.defaultProxySelector);
    }

    private boolean isRoutedURI(@NotNull URI uri) {
        if (!this.isSupportedScheme(uri.getScheme())) {
            return false;
        }
        for (URI routedURI : this.routedResources) {
            if (!uri.toString().startsWith(routedURI.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isSupportedScheme(@NotNull String scheme) {
        return Arrays.asList(SUPPORTED_SCHEMES).contains(scheme);
    }
}

