/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.rest;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.openapi.AuthUserCertificates;
import net.webpdf.wsclient.openapi.AuthUserCredentials;
import net.webpdf.wsclient.openapi.KeyStorePassword;
import net.webpdf.wsclient.session.AbstractSession;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.auth.AuthProvider;
import net.webpdf.wsclient.session.connection.SessionContext;
import net.webpdf.wsclient.session.connection.http.HttpAuthorizationHandler;
import net.webpdf.wsclient.session.connection.http.HttpMethod;
import net.webpdf.wsclient.session.connection.http.HttpRestRequest;
import net.webpdf.wsclient.session.rest.RestSession;
import net.webpdf.wsclient.session.rest.administration.AdministrationManager;
import net.webpdf.wsclient.session.rest.documents.DocumentManager;
import net.webpdf.wsclient.session.rest.documents.RestDocument;
import net.webpdf.wsclient.tools.SerializeHelper;
import net.webpdf.wsclient.webservice.WebServiceProtocol;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRestSession<T_REST_DOCUMENT extends RestDocument>
extends AbstractSession
implements RestSession<T_REST_DOCUMENT> {
    @NotNull
    private static final String INFO_PATH = "authentication/user/info/";
    @NotNull
    private static final String LOGOUT_PATH = "authentication/user/logout/";
    @NotNull
    private static final String CERTIFICATES_PATH = "authentication/user/certificates/";
    @Nullable
    private final AuthUserCredentials user;
    @NotNull
    private final CloseableHttpClient httpClient;
    @NotNull
    private final DocumentManager<T_REST_DOCUMENT> documentManager = this.createDocumentManager();
    @NotNull
    private final AdministrationManager<T_REST_DOCUMENT> administrationManager = this.createAdministrationManager();
    @Nullable
    private AuthUserCertificates certificates;

    public AbstractRestSession(@NotNull SessionContext serverContext, @NotNull AuthProvider authProvider) throws ResultException {
        super(WebServiceProtocol.REST, serverContext, authProvider);
        RequestConfig clientConfig = RequestConfig.custom().setAuthenticationEnabled(true).build();
        HttpAuthorizationHandler requestAuthorization = new HttpAuthorizationHandler(this);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(clientConfig).addExecInterceptorAfter(ChainElement.REDIRECT.name(), requestAuthorization.getExecChainHandlerName(), (ExecChainHandler)requestAuthorization);
        if (this.getSessionContext().getProxy() != null) {
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(this.getSessionContext().getProxy().getHost()));
        }
        if (serverContext.getTlsContext() != null) {
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(serverContext.getTlsContext().create(), (hostname, session) -> true);
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(registry));
        }
        this.httpClient = httpClientBuilder.build();
        this.user = HttpRestRequest.createRequest(this).buildRequest(HttpMethod.GET, INFO_PATH).executeRequest(AuthUserCredentials.class);
        this.certificates = HttpRestRequest.createRequest(this).buildRequest(HttpMethod.GET, CERTIFICATES_PATH).executeRequest(AuthUserCertificates.class);
    }

    @Override
    @NotNull
    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    @NotNull
    public DocumentManager<T_REST_DOCUMENT> getDocumentManager() {
        return this.documentManager;
    }

    @Override
    @NotNull
    public AdministrationManager<T_REST_DOCUMENT> getAdministrationManager() {
        return this.administrationManager;
    }

    @Override
    @Nullable
    public AuthUserCredentials getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public AuthUserCertificates getCertificates() {
        return this.certificates;
    }

    @Override
    @Nullable
    public AuthUserCertificates updateCertificates(String keystoreName, KeyStorePassword keyStorePassword) throws ResultException {
        this.certificates = HttpRestRequest.createRequest(this).buildRequest(HttpMethod.PUT, "authentication/user/certificates/passwords/" + keystoreName, this.prepareHttpEntity(keyStorePassword)).executeRequest(AuthUserCertificates.class);
        return this.certificates;
    }

    @Override
    public void close() throws ResultException {
        ClientResultException resultException = null;
        try {
            HttpRestRequest.createRequest(this).buildRequest(HttpMethod.GET, LOGOUT_PATH).executeRequest(Object.class);
        }
        finally {
            try {
                this.httpClient.close();
            }
            catch (IOException ex) {
                resultException = new ClientResultException(Error.HTTP_IO_ERROR, ex);
            }
        }
        if (resultException != null) {
            throw resultException;
        }
    }

    @NotNull
    private <T> HttpEntity prepareHttpEntity(@NotNull T parameter) throws ResultException {
        try {
            return new StringEntity(SerializeHelper.toJSON(parameter), ContentType.create((String)DataFormat.JSON.getMimeType(), (Charset)StandardCharsets.UTF_8));
        }
        catch (UnsupportedCharsetException ex) {
            throw new ClientResultException(Error.XML_OR_JSON_CONVERSION_FAILURE, ex);
        }
    }

    @NotNull
    protected abstract DocumentManager<T_REST_DOCUMENT> createDocumentManager();

    @NotNull
    protected abstract AdministrationManager<T_REST_DOCUMENT> createAdministrationManager();
}

