/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session;

import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.session.auth.AnonymousAuthProvider;
import net.webpdf.wsclient.session.auth.AuthProvider;
import net.webpdf.wsclient.session.connection.SessionContext;
import net.webpdf.wsclient.session.rest.RestWebServiceSession;
import net.webpdf.wsclient.session.soap.SoapWebServiceSession;
import org.jetbrains.annotations.NotNull;

public final class SessionFactory {
    private SessionFactory() {
    }

    @NotNull
    public static <T_SESSION extends Session> T_SESSION createInstance(@NotNull SessionContext sessionContext) throws ResultException {
        return SessionFactory.createInstance(sessionContext, new AnonymousAuthProvider());
    }

    @NotNull
    public static <T_SESSION extends Session> T_SESSION createInstance(@NotNull SessionContext sessionContext, @NotNull AuthProvider authProvider) throws ResultException {
        try {
            switch (sessionContext.getWebServiceProtocol()) {
                case SOAP: {
                    return (T_SESSION)new SoapWebServiceSession(sessionContext, authProvider);
                }
                case REST: {
                    return (T_SESSION)new RestWebServiceSession(sessionContext, authProvider);
                }
            }
            throw new ClientResultException(Error.UNKNOWN_SESSION_TYPE);
        }
        catch (ClassCastException ex) {
            throw new ClientResultException(Error.UNKNOWN_SESSION_TYPE, ex);
        }
    }
}

