/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ServerConfigHostCsp;
import net.webpdf.wsclient.openapi.ServerConfigHostFilter;
import net.webpdf.wsclient.openapi.ServerConfigHostValve;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the host name and context path of the server.")
@JsonPropertyOrder(value={"contextPath", "csp", "filter", "name", "valve"})
@JsonTypeName(value="ServerConfig_Host")
public class ServerConfigHost {
    public static final String JSON_PROPERTY_CONTEXT_PATH = "contextPath";
    private String contextPath = "webPDF";
    public static final String JSON_PROPERTY_CSP = "csp";
    private ServerConfigHostCsp csp;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private List<ServerConfigHostFilter> filter = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "localhost";
    public static final String JSON_PROPERTY_VALVE = "valve";
    private List<ServerConfigHostValve> valve = null;

    public ServerConfigHost contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Schema(name="Sets the context path of the server address for the portal and the web services (e.g., http://localhost/webPDF).")
    @JsonProperty(value="contextPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getContextPath() {
        return this.contextPath;
    }

    @JsonProperty(value="contextPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public ServerConfigHost csp(ServerConfigHostCsp csp) {
        this.csp = csp;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="csp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigHostCsp getCsp() {
        return this.csp;
    }

    @JsonProperty(value="csp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCsp(ServerConfigHostCsp csp) {
        this.csp = csp;
    }

    public ServerConfigHost filter(List<ServerConfigHostFilter> filter) {
        this.filter = filter;
        return this;
    }

    public ServerConfigHost addFilterItem(ServerConfigHostFilter filterItem) {
        if (this.filter == null) {
            this.filter = new ArrayList<ServerConfigHostFilter>();
        }
        this.filter.add(filterItem);
        return this;
    }

    @Schema(name="A `filter` element represents a component to insert into the request processing pipeline of the underlying Tomcat server. (See: https://tomcat.apache.org/tomcat-10.1-doc/config/filter.html for further information.)")
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<ServerConfigHostFilter> getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(List<ServerConfigHostFilter> filter) {
        this.filter = filter;
    }

    public ServerConfigHost name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Sets the host name part of the server address (e.g. http://localhost).")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ServerConfigHost valve(List<ServerConfigHostValve> valve) {
        this.valve = valve;
        return this;
    }

    public ServerConfigHost addValveItem(ServerConfigHostValve valveItem) {
        if (this.valve == null) {
            this.valve = new ArrayList<ServerConfigHostValve>();
        }
        this.valve.add(valveItem);
        return this;
    }

    @Schema(name="A `valve` element represents a component to insert into the request processing pipeline of the underlying Tomcat server. (See: https://tomcat.apache.org/tomcat-10.1-doc/config/valve.html for further information.)")
    @JsonProperty(value="valve")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<ServerConfigHostValve> getValve() {
        return this.valve;
    }

    @JsonProperty(value="valve")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValve(List<ServerConfigHostValve> valve) {
        this.valve = valve;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigHost serverConfigHost = (ServerConfigHost)o;
        return Objects.equals(this.contextPath, serverConfigHost.contextPath) && Objects.equals(this.csp, serverConfigHost.csp) && Objects.equals(this.filter, serverConfigHost.filter) && Objects.equals(this.name, serverConfigHost.name) && Objects.equals(this.valve, serverConfigHost.valve);
    }

    public int hashCode() {
        return Objects.hash(this.contextPath, this.csp, this.filter, this.name, this.valve);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigHost {\n");
        sb.append("    contextPath: ").append(this.toIndentedString(this.contextPath)).append("\n");
        sb.append("    csp: ").append(this.toIndentedString(this.csp)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    valve: ").append(this.toIndentedString(this.valve)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

