/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationMergeFileData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="The merge operation element can be used to merge documents.  **Important:** When a \"merge\" operation is performed, the pages and structural information (such as outlines and tag) will be merged. This can result in name conflicts that can prevent a success. If you would rather like to ignore such conflicts use the matching \"ignoreConflicts\" parameter.  **Important:** Merging documents could also fail because of signatures or a used PDF/A format. As  *   by definition - altering PDF/A documents and signed documents would result in an invalidation of such documents/signatures.")
@JsonPropertyOrder(value={"data", "mode", "outlineName", "page", "removeStaticXFA", "resetMetadata", "sourceIsZip"})
@JsonTypeName(value="Operation_ToolboxMerge_merge")
public class OperationToolboxMergeMerge {
    public static final String JSON_PROPERTY_DATA = "data";
    private OperationMergeFileData data;
    public static final String JSON_PROPERTY_MODE = "mode";
    private ModeEnum mode = ModeEnum.AT_THE_END;
    public static final String JSON_PROPERTY_OUTLINE_NAME = "outlineName";
    private String outlineName = "";
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_REMOVE_STATIC_X_F_A = "removeStaticXFA";
    private Boolean removeStaticXFA = false;
    public static final String JSON_PROPERTY_RESET_METADATA = "resetMetadata";
    private Boolean resetMetadata = false;
    public static final String JSON_PROPERTY_SOURCE_IS_ZIP = "sourceIsZip";
    private Boolean sourceIsZip = false;

    public OperationToolboxMergeMerge data(OperationMergeFileData data) {
        this.data = data;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationMergeFileData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(OperationMergeFileData data) {
        this.data = data;
    }

    public OperationToolboxMergeMerge mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="Defines the mode used to merge the PDF documents. The PDF document passed with the \"data\" element will be appended to the current PDF document or inserted at a specific point. The following modes define the position where the documents will be inserted. Instead of a single base document, the \"portfolio\" mode always expects a ZIP archive. The elements in this archive will be added, all with identical permissions, to the resulting portfolio (the data element is not required at all for \"portfolio\").  *   atTheEnd = At the end of the PDF document *   atTheBeginning = At the beginning of the PDF document *   afterPage = After a page (please refer to the \"page\" attribute) in the PDF document *   beforePage = Before a page (please refer to the \"page\" attribute) in the PDF document")
    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ModeEnum getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public OperationToolboxMergeMerge outlineName(String outlineName) {
        this.outlineName = outlineName;
        return this;
    }

    @Schema(name="Used to define the base path that should be used for outline nodes of the source document. This parameter can contain a slash separated path and should ideally end with the name of the document (\"A/B/filename\"). If this parameter is not set, all outlines will be appended to the root outline node.")
    @JsonProperty(value="outlineName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getOutlineName() {
        return this.outlineName;
    }

    @JsonProperty(value="outlineName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutlineName(String outlineName) {
        this.outlineName = outlineName;
    }

    public OperationToolboxMergeMerge page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="Used to define the page number where the PDF document should be inserted.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationToolboxMergeMerge removeStaticXFA(Boolean removeStaticXFA) {
        this.removeStaticXFA = removeStaticXFA;
        return this;
    }

    @Schema(name="If this parameter is enabled, all entries related to static XFA documents and all connected extended permission settings will be removed from the document. Using this parameter it is possible to merge static XFA documents with other documents, which is normally forbidden by default.  **Important:** Although this parameter allows the merging of static XFA documents, this will not create a valid static XFA document as a result. All structures qualifying a document as a static XFA document will be removed. The resulting document will contain a pure Acroform and will not be recognized as a XFA form by applications for XFA creation/editing. Also, all extended access  *   and write permissions will be removed (That normally can expected to be found in a static XFA document).")
    @JsonProperty(value="removeStaticXFA")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRemoveStaticXFA() {
        return this.removeStaticXFA;
    }

    @JsonProperty(value="removeStaticXFA")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemoveStaticXFA(Boolean removeStaticXFA) {
        this.removeStaticXFA = removeStaticXFA;
    }

    public OperationToolboxMergeMerge resetMetadata(Boolean resetMetadata) {
        this.resetMetadata = resetMetadata;
        return this;
    }

    @Schema(name="If you enable this parameter, the source document's metadata will be removed and replaced with default values.")
    @JsonProperty(value="resetMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getResetMetadata() {
        return this.resetMetadata;
    }

    @JsonProperty(value="resetMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResetMetadata(Boolean resetMetadata) {
        this.resetMetadata = resetMetadata;
    }

    public OperationToolboxMergeMerge sourceIsZip(Boolean sourceIsZip) {
        this.sourceIsZip = sourceIsZip;
        return this;
    }

    @Schema(name="If this parameter is enabled, a ZIP archive  *   containing the documents to merge - will be expected as the webservice's source document. Also - in that case, the \"data\" parameter is not required. The first element in the ZIP archive will be used as a base document to which all following entries will be appended.  **Important:**The usage of this parameter is expected to be used for the \"portfolio\" mode. All the documents in the ZIP archive will be added to the portfolio receiving identical permission settings.")
    @JsonProperty(value="sourceIsZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getSourceIsZip() {
        return this.sourceIsZip;
    }

    @JsonProperty(value="sourceIsZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceIsZip(Boolean sourceIsZip) {
        this.sourceIsZip = sourceIsZip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationToolboxMergeMerge operationToolboxMergeMerge = (OperationToolboxMergeMerge)o;
        return Objects.equals(this.data, operationToolboxMergeMerge.data) && Objects.equals((Object)this.mode, (Object)operationToolboxMergeMerge.mode) && Objects.equals(this.outlineName, operationToolboxMergeMerge.outlineName) && Objects.equals(this.page, operationToolboxMergeMerge.page) && Objects.equals(this.removeStaticXFA, operationToolboxMergeMerge.removeStaticXFA) && Objects.equals(this.resetMetadata, operationToolboxMergeMerge.resetMetadata) && Objects.equals(this.sourceIsZip, operationToolboxMergeMerge.sourceIsZip);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.mode, this.outlineName, this.page, this.removeStaticXFA, this.resetMetadata, this.sourceIsZip});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationToolboxMergeMerge {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    outlineName: ").append(this.toIndentedString(this.outlineName)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    removeStaticXFA: ").append(this.toIndentedString(this.removeStaticXFA)).append("\n");
        sb.append("    resetMetadata: ").append(this.toIndentedString(this.resetMetadata)).append("\n");
        sb.append("    sourceIsZip: ").append(this.toIndentedString(this.sourceIsZip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        AT_THE_END(String.valueOf("atTheEnd")),
        AT_THE_BEGINNING(String.valueOf("atTheBeginning")),
        AFTER_PAGE(String.valueOf("afterPage")),
        BEFORE_PAGE(String.valueOf("beforePage"));

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

