/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="A font definition for textual annotation types.")
@JsonPropertyOrder(value={"bold", "color", "italic", "name", "size"})
@JsonTypeName(value="Operation_FreeTextFont")
public class OperationFreeTextFont {
    public static final String JSON_PROPERTY_BOLD = "bold";
    private Boolean bold = false;
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#A0A0A0";
    public static final String JSON_PROPERTY_ITALIC = "italic";
    private Boolean italic = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_SIZE = "size";
    private Integer size = 24;

    public OperationFreeTextFont bold(Boolean bold) {
        this.bold = bold;
        return this;
    }

    @Schema(name="Used to increase the text output's weight.")
    @JsonProperty(value="bold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getBold() {
        return this.bold;
    }

    @JsonProperty(value="bold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public OperationFreeTextFont color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="Used to set the font color. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public OperationFreeTextFont italic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    @Schema(name="Used to set the italic font posture for the text output.")
    @JsonProperty(value="italic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getItalic() {
        return this.italic;
    }

    @JsonProperty(value="italic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public OperationFreeTextFont name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Used to specify the name of the font that should be used for the text output.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationFreeTextFont size(Integer size) {
        this.size = size;
        return this;
    }

    @Schema(name="Used to set the text size for the text output.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationFreeTextFont operationFreeTextFont = (OperationFreeTextFont)o;
        return Objects.equals(this.bold, operationFreeTextFont.bold) && Objects.equals(this.color, operationFreeTextFont.color) && Objects.equals(this.italic, operationFreeTextFont.italic) && Objects.equals(this.name, operationFreeTextFont.name) && Objects.equals(this.size, operationFreeTextFont.size);
    }

    public int hashCode() {
        return Objects.hash(this.bold, this.color, this.italic, this.name, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationFreeTextFont {\n");
        sb.append("    bold: ").append(this.toIndentedString(this.bold)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    italic: ").append(this.toIndentedString(this.italic)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

