/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Extract the PDF document's image contents  Generates a ZIP file that is returned as a result when the web service is called. This file will contain all the images contained at the page level in a freely selectable page range.  **Important:** The images mode can only be used to extract raster graphics (bitmap images). The extraction vector graphics, as well as the rendering of vector graphics based on vectorial drawing paths, is not supported.  **Important:** Due to licensing reasons, the images mode currently only supports the extraction of basic JPEG2000 images that conform to the part-1 core coding system definition in ISO/IEC 15444-1.  **Important:** It cannot be guaranteed that an image will be exported in its original source format, as the image may have already been converted when embedded in the PDF (this depends on whether the source format was supported by the PDF standard and on the application that was used to embed the image).")
@JsonPropertyOrder(value={"fallbackFormat", "fileFormat", "fileNameTemplate", "folderNameTemplate", "pages"})
@JsonTypeName(value="Operation_ExtractionImages")
public class OperationExtractionImages {
    public static final String JSON_PROPERTY_FALLBACK_FORMAT = "fallbackFormat";
    private FallbackFormatEnum fallbackFormat = FallbackFormatEnum.PNG;
    public static final String JSON_PROPERTY_FILE_FORMAT = "fileFormat";
    private FileFormatEnum fileFormat = FileFormatEnum.ZIP;
    public static final String JSON_PROPERTY_FILE_NAME_TEMPLATE = "fileNameTemplate";
    private String fileNameTemplate = "file[%d]";
    public static final String JSON_PROPERTY_FOLDER_NAME_TEMPLATE = "folderNameTemplate";
    private String folderNameTemplate = "page[%d]";
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "";

    public OperationExtractionImages fallbackFormat(FallbackFormatEnum fallbackFormat) {
        this.fallbackFormat = fallbackFormat;
        return this;
    }

    @Schema(name="Used to specify the format that should be used as the fallback format if extracting an image would result in a format that is not supported.  *   png = PNG file *   jpeg = JPEG file")
    @JsonProperty(value="fallbackFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FallbackFormatEnum getFallbackFormat() {
        return this.fallbackFormat;
    }

    @JsonProperty(value="fallbackFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFallbackFormat(FallbackFormatEnum fallbackFormat) {
        this.fallbackFormat = fallbackFormat;
    }

    public OperationExtractionImages fileFormat(FileFormatEnum fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @Schema(name="Used to define the output format for the PDF document text contents being extracted.  *   text = Text document *   xml = XML document *   json = JSON data structure")
    @JsonProperty(value="fileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FileFormatEnum getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty(value="fileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileFormat(FileFormatEnum fileFormat) {
        this.fileFormat = fileFormat;
    }

    public OperationExtractionImages fileNameTemplate(String fileNameTemplate) {
        this.fileNameTemplate = fileNameTemplate;
        return this;
    }

    @Schema(name="Used to set the template for the image files in the returned ZIP file. \"file\\[%d\\]\", for example, would result in a \"file\\[1\\].png\" entry for a PNG image.")
    @JsonProperty(value="fileNameTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileNameTemplate() {
        return this.fileNameTemplate;
    }

    @JsonProperty(value="fileNameTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileNameTemplate(String fileNameTemplate) {
        this.fileNameTemplate = fileNameTemplate;
    }

    public OperationExtractionImages folderNameTemplate(String folderNameTemplate) {
        this.folderNameTemplate = folderNameTemplate;
        return this;
    }

    @Schema(name="Used to set the template for the page folders in the returned ZIP file. \"page\\[%d\\]\", for example, would result in a folder called \"page\\[1\\]\" for page 1, etc.")
    @JsonProperty(value="folderNameTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFolderNameTemplate() {
        return this.folderNameTemplate;
    }

    @JsonProperty(value="folderNameTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFolderNameTemplate(String folderNameTemplate) {
        this.folderNameTemplate = folderNameTemplate;
    }

    public OperationExtractionImages pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Used to define which page(s) should be used for the image's mode. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). A blank value or \"\\*\" selects all pages of the PDF document.")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationExtractionImages operationExtractionImages = (OperationExtractionImages)o;
        return Objects.equals((Object)this.fallbackFormat, (Object)operationExtractionImages.fallbackFormat) && Objects.equals((Object)this.fileFormat, (Object)operationExtractionImages.fileFormat) && Objects.equals(this.fileNameTemplate, operationExtractionImages.fileNameTemplate) && Objects.equals(this.folderNameTemplate, operationExtractionImages.folderNameTemplate) && Objects.equals(this.pages, operationExtractionImages.pages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fallbackFormat, this.fileFormat, this.fileNameTemplate, this.folderNameTemplate, this.pages});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationExtractionImages {\n");
        sb.append("    fallbackFormat: ").append(this.toIndentedString((Object)this.fallbackFormat)).append("\n");
        sb.append("    fileFormat: ").append(this.toIndentedString((Object)this.fileFormat)).append("\n");
        sb.append("    fileNameTemplate: ").append(this.toIndentedString(this.fileNameTemplate)).append("\n");
        sb.append("    folderNameTemplate: ").append(this.toIndentedString(this.folderNameTemplate)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FileFormatEnum {
        TEXT(String.valueOf("text")),
        XML(String.valueOf("xml")),
        JSON(String.valueOf("json")),
        ZIP(String.valueOf("zip"));

        private String value;

        private FileFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FileFormatEnum fromValue(String value) {
            for (FileFormatEnum b : FileFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FallbackFormatEnum {
        PNG(String.valueOf("png")),
        JPEG(String.valueOf("jpeg"));

        private String value;

        private FallbackFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FallbackFormatEnum fromValue(String value) {
            for (FallbackFormatEnum b : FallbackFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

