/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationCompressObjects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The `compress` element can be used to automatically compress the contents of the PDF document when saving it. Whenever the web service operation saves the PDF document, it should try to compress it according to the settings specified here. Document compression can also be triggered specifically via the 'compress' web service instead.")
@JsonPropertyOrder(value={"compressObjects", "compressProfile"})
@JsonTypeName(value="Operation_CompressSettings")
public class OperationCompressSettings {
    public static final String JSON_PROPERTY_COMPRESS_OBJECTS = "compressObjects";
    private OperationCompressObjects compressObjects;
    public static final String JSON_PROPERTY_COMPRESS_PROFILE = "compressProfile";
    private CompressProfileEnum compressProfile = CompressProfileEnum.NEVER;

    public OperationCompressSettings compressObjects(OperationCompressObjects compressObjects) {
        this.compressObjects = compressObjects;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="compressObjects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationCompressObjects getCompressObjects() {
        return this.compressObjects;
    }

    @JsonProperty(value="compressObjects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompressObjects(OperationCompressObjects compressObjects) {
        this.compressObjects = compressObjects;
    }

    public OperationCompressSettings compressProfile(CompressProfileEnum compressProfile) {
        this.compressProfile = compressProfile;
        return this;
    }

    @Schema(name="Sets the profile for automatic document compression and thus defines whether compression should be applied when saving.  *   always = PDF documents should always be compressed when saved. *   never = PDF documents should not be automatically compressed. *   recompress = PDF documents should only be compressed automatically if they were already compressed previously.")
    @JsonProperty(value="compressProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public CompressProfileEnum getCompressProfile() {
        return this.compressProfile;
    }

    @JsonProperty(value="compressProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompressProfile(CompressProfileEnum compressProfile) {
        this.compressProfile = compressProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationCompressSettings operationCompressSettings = (OperationCompressSettings)o;
        return Objects.equals(this.compressObjects, operationCompressSettings.compressObjects) && Objects.equals((Object)this.compressProfile, (Object)operationCompressSettings.compressProfile);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.compressObjects, this.compressProfile});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationCompressSettings {\n");
        sb.append("    compressObjects: ").append(this.toIndentedString(this.compressObjects)).append("\n");
        sb.append("    compressProfile: ").append(this.toIndentedString((Object)this.compressProfile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CompressProfileEnum {
        ALWAYS(String.valueOf("always")),
        NEVER(String.valueOf("never")),
        RECOMPRESS(String.valueOf("recompress"));

        private String value;

        private CompressProfileEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CompressProfileEnum fromValue(String value) {
            for (CompressProfileEnum b : CompressProfileEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

