/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Properties listed in the Adobe piece info.")
@JsonPropertyOrder(value={"absoluteScaling", "alignment", "color", "horizOffset", "opacity", "rotation", "scale", "unit", "vertOffset"})
@JsonTypeName(value="Metadata_PieceInfoBackgroundContent")
public class MetadataPieceInfoBackgroundContent {
    public static final String JSON_PROPERTY_ABSOLUTE_SCALING = "absoluteScaling";
    private Boolean absoluteScaling = true;
    public static final String JSON_PROPERTY_ALIGNMENT = "alignment";
    private AlignmentEnum alignment = AlignmentEnum.TOP_LEFT;
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#FFFFFF";
    public static final String JSON_PROPERTY_HORIZ_OFFSET = "horizOffset";
    private Float horizOffset = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_OPACITY = "opacity";
    private Float opacity = Float.valueOf(1.0f);
    public static final String JSON_PROPERTY_ROTATION = "rotation";
    private Integer rotation = 0;
    public static final String JSON_PROPERTY_SCALE = "scale";
    private Float scale = Float.valueOf(1.0f);
    public static final String JSON_PROPERTY_UNIT = "unit";
    private String unit = "";
    public static final String JSON_PROPERTY_VERT_OFFSET = "vertOffset";
    private Float vertOffset = Float.valueOf(0.0f);

    public MetadataPieceInfoBackgroundContent absoluteScaling(Boolean absoluteScaling) {
        this.absoluteScaling = absoluteScaling;
        return this;
    }

    @Schema(name="When set to true the page shall be scaled relative to it's own original dimensions, when set to false, it shall be scaled relative to the page dimensions.")
    @JsonProperty(value="absoluteScaling")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAbsoluteScaling() {
        return this.absoluteScaling;
    }

    @JsonProperty(value="absoluteScaling")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAbsoluteScaling(Boolean absoluteScaling) {
        this.absoluteScaling = absoluteScaling;
    }

    public MetadataPieceInfoBackgroundContent alignment(AlignmentEnum alignment) {
        this.alignment = alignment;
        return this;
    }

    @Schema(name="Uses one of multiple preset positions in order to position the background on the page.  *   custom = Disable the use of a preset position. *   top\\_left = Positions the background in the top left corner. *   top\\_center = Positions the background in the centre on the top margin. *   top\\_right = Positions the background in the top right corner. *   center\\_left = Positions the background at the centre of the page, to the left. *   center\\_center = Positions the background at the centre of the page. *   center\\_right = Positions the background at the centre of the page, to the right. *   bottom\\_left = Positions the background in the bottom left corner. *   bottom\\_center = Positions the background in the centre on the bottom margin. *   bottom\\_right = Positions the background in the bottom right corner.")
    @JsonProperty(value="alignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public AlignmentEnum getAlignment() {
        return this.alignment;
    }

    @JsonProperty(value="alignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlignment(AlignmentEnum alignment) {
        this.alignment = alignment;
    }

    public MetadataPieceInfoBackgroundContent color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="The color of a unicolor background.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public MetadataPieceInfoBackgroundContent horizOffset(Float horizOffset) {
        this.horizOffset = horizOffset;
        return this;
    }

    @Schema(name="The horizontal offset in relation to the backgrounds bas position.")
    @JsonProperty(value="horizOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getHorizOffset() {
        return this.horizOffset;
    }

    @JsonProperty(value="horizOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHorizOffset(Float horizOffset) {
        this.horizOffset = horizOffset;
    }

    public MetadataPieceInfoBackgroundContent opacity(Float opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="The opacity of the background, as a percentage in the range 0.0 (fully transparent) to 1.0 (fully opaque).")
    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getOpacity() {
        return this.opacity;
    }

    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpacity(Float opacity) {
        this.opacity = opacity;
    }

    public MetadataPieceInfoBackgroundContent rotation(Integer rotation) {
        this.rotation = rotation;
        return this;
    }

    @Schema(name="The rotation of the background.")
    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getRotation() {
        return this.rotation;
    }

    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRotation(Integer rotation) {
        this.rotation = rotation;
    }

    public MetadataPieceInfoBackgroundContent scale(Float scale) {
        this.scale = scale;
        return this;
    }

    @Schema(name="The scaling of the background.")
    @JsonProperty(value="scale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getScale() {
        return this.scale;
    }

    @JsonProperty(value="scale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScale(Float scale) {
        this.scale = scale;
    }

    public MetadataPieceInfoBackgroundContent unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Schema(name="The Adobe unit used to display offsets in readers. (millimeters, pica, point etc).")
    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUnit() {
        return this.unit;
    }

    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnit(String unit) {
        this.unit = unit;
    }

    public MetadataPieceInfoBackgroundContent vertOffset(Float vertOffset) {
        this.vertOffset = vertOffset;
        return this;
    }

    @Schema(name="The vertical offset in relation to the backgrounds bas position.")
    @JsonProperty(value="vertOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getVertOffset() {
        return this.vertOffset;
    }

    @JsonProperty(value="vertOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVertOffset(Float vertOffset) {
        this.vertOffset = vertOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataPieceInfoBackgroundContent metadataPieceInfoBackgroundContent = (MetadataPieceInfoBackgroundContent)o;
        return Objects.equals(this.absoluteScaling, metadataPieceInfoBackgroundContent.absoluteScaling) && Objects.equals((Object)this.alignment, (Object)metadataPieceInfoBackgroundContent.alignment) && Objects.equals(this.color, metadataPieceInfoBackgroundContent.color) && Objects.equals(this.horizOffset, metadataPieceInfoBackgroundContent.horizOffset) && Objects.equals(this.opacity, metadataPieceInfoBackgroundContent.opacity) && Objects.equals(this.rotation, metadataPieceInfoBackgroundContent.rotation) && Objects.equals(this.scale, metadataPieceInfoBackgroundContent.scale) && Objects.equals(this.unit, metadataPieceInfoBackgroundContent.unit) && Objects.equals(this.vertOffset, metadataPieceInfoBackgroundContent.vertOffset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.absoluteScaling, this.alignment, this.color, this.horizOffset, this.opacity, this.rotation, this.scale, this.unit, this.vertOffset});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataPieceInfoBackgroundContent {\n");
        sb.append("    absoluteScaling: ").append(this.toIndentedString(this.absoluteScaling)).append("\n");
        sb.append("    alignment: ").append(this.toIndentedString((Object)this.alignment)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    horizOffset: ").append(this.toIndentedString(this.horizOffset)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    rotation: ").append(this.toIndentedString(this.rotation)).append("\n");
        sb.append("    scale: ").append(this.toIndentedString(this.scale)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    vertOffset: ").append(this.toIndentedString(this.vertOffset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AlignmentEnum {
        TOP_LEFT(String.valueOf("top_left")),
        TOP_CENTER(String.valueOf("top_center")),
        TOP_RIGHT(String.valueOf("top_right")),
        CENTER_LEFT(String.valueOf("center_left")),
        CENTER_CENTER(String.valueOf("center_center")),
        CENTER_RIGHT(String.valueOf("center_right")),
        BOTTOM_LEFT(String.valueOf("bottom_left")),
        BOTTOM_CENTER(String.valueOf("bottom_center")),
        BOTTOM_RIGHT(String.valueOf("bottom_right"));

        private String value;

        private AlignmentEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AlignmentEnum fromValue(String value) {
            for (AlignmentEnum b : AlignmentEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

