/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ClusterNodeStatus;
import net.webpdf.wsclient.openapi.ClusterSettings;
import net.webpdf.wsclient.openapi.WebserviceResult;
import org.jetbrains.annotations.Nullable;

@Schema(description="General information about the cluster status and detailed information about each node.")
@JsonPropertyOrder(value={"error", "id", "isDemoMode", "localAddress", "maximumAllowedNodes", "namespace", "nodes", "settings"})
@JsonTypeName(value="Cluster_Status")
public class ClusterStatus {
    public static final String JSON_PROPERTY_ERROR = "error";
    private WebserviceResult error;
    public static final String JSON_PROPERTY_ID = "id";
    private String id = "";
    public static final String JSON_PROPERTY_IS_DEMO_MODE = "isDemoMode";
    private Boolean isDemoMode = false;
    public static final String JSON_PROPERTY_LOCAL_ADDRESS = "localAddress";
    private String localAddress = "";
    public static final String JSON_PROPERTY_MAXIMUM_ALLOWED_NODES = "maximumAllowedNodes";
    private Integer maximumAllowedNodes = 0;
    public static final String JSON_PROPERTY_NAMESPACE = "namespace";
    private String namespace = "";
    public static final String JSON_PROPERTY_NODES = "nodes";
    private List<ClusterNodeStatus> nodes = null;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private ClusterSettings settings;

    public ClusterStatus error(WebserviceResult error) {
        this.error = error;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public WebserviceResult getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(WebserviceResult error) {
        this.error = error;
    }

    public ClusterStatus id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ClusterStatus isDemoMode(Boolean isDemoMode) {
        this.isDemoMode = isDemoMode;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="isDemoMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsDemoMode() {
        return this.isDemoMode;
    }

    @JsonProperty(value="isDemoMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsDemoMode(Boolean isDemoMode) {
        this.isDemoMode = isDemoMode;
    }

    public ClusterStatus localAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="localAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getLocalAddress() {
        return this.localAddress;
    }

    @JsonProperty(value="localAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public ClusterStatus maximumAllowedNodes(Integer maximumAllowedNodes) {
        this.maximumAllowedNodes = maximumAllowedNodes;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="maximumAllowedNodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMaximumAllowedNodes() {
        return this.maximumAllowedNodes;
    }

    @JsonProperty(value="maximumAllowedNodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaximumAllowedNodes(Integer maximumAllowedNodes) {
        this.maximumAllowedNodes = maximumAllowedNodes;
    }

    public ClusterStatus namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ClusterStatus nodes(List<ClusterNodeStatus> nodes) {
        this.nodes = nodes;
        return this;
    }

    public ClusterStatus addNodesItem(ClusterNodeStatus nodesItem) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<ClusterNodeStatus>();
        }
        this.nodes.add(nodesItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="nodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<ClusterNodeStatus> getNodes() {
        return this.nodes;
    }

    @JsonProperty(value="nodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNodes(List<ClusterNodeStatus> nodes) {
        this.nodes = nodes;
    }

    public ClusterStatus settings(ClusterSettings settings) {
        this.settings = settings;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ClusterSettings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(ClusterSettings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStatus clusterStatus = (ClusterStatus)o;
        return Objects.equals(this.error, clusterStatus.error) && Objects.equals(this.id, clusterStatus.id) && Objects.equals(this.isDemoMode, clusterStatus.isDemoMode) && Objects.equals(this.localAddress, clusterStatus.localAddress) && Objects.equals(this.maximumAllowedNodes, clusterStatus.maximumAllowedNodes) && Objects.equals(this.namespace, clusterStatus.namespace) && Objects.equals(this.nodes, clusterStatus.nodes) && Objects.equals(this.settings, clusterStatus.settings);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.id, this.isDemoMode, this.localAddress, this.maximumAllowedNodes, this.namespace, this.nodes, this.settings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClusterStatus {\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isDemoMode: ").append(this.toIndentedString(this.isDemoMode)).append("\n");
        sb.append("    localAddress: ").append(this.toIndentedString(this.localAddress)).append("\n");
        sb.append("    maximumAllowedNodes: ").append(this.toIndentedString(this.maximumAllowedNodes)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    nodes: ").append(this.toIndentedString(this.nodes)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

