/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ClusterMode;
import net.webpdf.wsclient.openapi.ClusterRole;
import org.jetbrains.annotations.Nullable;

@Schema(description="Settings for the cluster")
@JsonPropertyOrder(value={"connectTimeout", "mode", "name", "nodeName", "role", "secretKey", "stopOnError"})
@JsonTypeName(value="Cluster_Settings")
public class ClusterSettings {
    public static final String JSON_PROPERTY_CONNECT_TIMEOUT = "connectTimeout";
    private Integer connectTimeout = 0;
    public static final String JSON_PROPERTY_MODE = "mode";
    private ClusterMode mode = ClusterMode.SINGLE;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_NODE_NAME = "nodeName";
    private String nodeName = "";
    public static final String JSON_PROPERTY_ROLE = "role";
    private ClusterRole role = ClusterRole.MEMBER;
    public static final String JSON_PROPERTY_SECRET_KEY = "secretKey";
    private String secretKey = "";
    public static final String JSON_PROPERTY_STOP_ON_ERROR = "stopOnError";
    private Boolean stopOnError = false;

    public ClusterSettings connectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Schema(name="Defines the number of milliseconds that a server node waits when it joins the cluster (e.g. when waiting for a coordinator server node)")
    @JsonProperty(value="connectTimeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @JsonProperty(value="connectTimeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public ClusterSettings mode(ClusterMode mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ClusterMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMode(ClusterMode mode) {
        this.mode = mode;
    }

    public ClusterSettings name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Defines the name of the cluster. If the server node has a coordinator role, the cluster is created under this name. If the server node has the role of a member, the node attempts to join the cluster with this name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ClusterSettings nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Schema(name="Defines the name for the node. If it is empty, the host name of the machine is used.")
    @JsonProperty(value="nodeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getNodeName() {
        return this.nodeName;
    }

    @JsonProperty(value="nodeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public ClusterSettings role(ClusterRole role) {
        this.role = role;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ClusterRole getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(ClusterRole role) {
        this.role = role;
    }

    public ClusterSettings secretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @Schema(name="The encryption key used for communication in the cluster between the nodes. All nodes must use the same 64-digit hexadecimal encryption key. The encryption key is created when the cluster is initialized.")
    @JsonProperty(value="secretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public ClusterSettings stopOnError(Boolean stopOnError) {
        this.stopOnError = stopOnError;
        return this;
    }

    @Schema(name="If 'true', the server node is also started if an error has occurred (e.g. when joining the cluster).")
    @JsonProperty(value="stopOnError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getStopOnError() {
        return this.stopOnError;
    }

    @JsonProperty(value="stopOnError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStopOnError(Boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterSettings clusterSettings = (ClusterSettings)o;
        return Objects.equals(this.connectTimeout, clusterSettings.connectTimeout) && Objects.equals((Object)this.mode, (Object)clusterSettings.mode) && Objects.equals(this.name, clusterSettings.name) && Objects.equals(this.nodeName, clusterSettings.nodeName) && Objects.equals((Object)this.role, (Object)clusterSettings.role) && Objects.equals(this.secretKey, clusterSettings.secretKey) && Objects.equals(this.stopOnError, clusterSettings.stopOnError);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectTimeout, this.mode, this.name, this.nodeName, this.role, this.secretKey, this.stopOnError});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClusterSettings {\n");
        sb.append("    connectTimeout: ").append(this.toIndentedString(this.connectTimeout)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    secretKey: ").append(this.toIndentedString(this.secretKey)).append("\n");
        sb.append("    stopOnError: ").append(this.toIndentedString(this.stopOnError)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

