/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OAuthOIDCMetadata;
import net.webpdf.wsclient.openapi.ServerConfigOAuthProviderLogout;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a general authorization provider")
@JsonPropertyOrder(value={"applicationId", "clientId", "displayName", "id", "logout", "name", "oidc", "scope"})
@JsonTypeName(value="Auth_Provider")
public class AuthProvider {
    public static final String JSON_PROPERTY_APPLICATION_ID = "applicationId";
    private String applicationId = "";
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId = "";
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName = "";
    public static final String JSON_PROPERTY_ID = "id";
    private String id = "";
    public static final String JSON_PROPERTY_LOGOUT = "logout";
    private ServerConfigOAuthProviderLogout logout;
    public static final String JSON_PROPERTY_NAME = "name";
    private NameEnum name = NameEnum.GENERIC;
    public static final String JSON_PROPERTY_OIDC = "oidc";
    private OAuthOIDCMetadata oidc;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope = "";

    public AuthProvider applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="applicationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="applicationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public AuthProvider clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AuthProvider displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public AuthProvider id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public AuthProvider logout(ServerConfigOAuthProviderLogout logout) {
        this.logout = logout;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="logout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigOAuthProviderLogout getLogout() {
        return this.logout;
    }

    @JsonProperty(value="logout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogout(ServerConfigOAuthProviderLogout logout) {
        this.logout = logout;
    }

    public AuthProvider name(NameEnum name) {
        this.name = name;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public NameEnum getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(NameEnum name) {
        this.name = name;
    }

    public AuthProvider oidc(OAuthOIDCMetadata oidc) {
        this.oidc = oidc;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="oidc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OAuthOIDCMetadata getOidc() {
        return this.oidc;
    }

    @JsonProperty(value="oidc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOidc(OAuthOIDCMetadata oidc) {
        this.oidc = oidc;
    }

    public AuthProvider scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthProvider authProvider = (AuthProvider)o;
        return Objects.equals(this.applicationId, authProvider.applicationId) && Objects.equals(this.clientId, authProvider.clientId) && Objects.equals(this.displayName, authProvider.displayName) && Objects.equals(this.id, authProvider.id) && Objects.equals(this.logout, authProvider.logout) && Objects.equals((Object)this.name, (Object)authProvider.name) && Objects.equals(this.oidc, authProvider.oidc) && Objects.equals(this.scope, authProvider.scope);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicationId, this.clientId, this.displayName, this.id, this.logout, this.name, this.oidc, this.scope});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthProvider {\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    logout: ").append(this.toIndentedString(this.logout)).append("\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    oidc: ").append(this.toIndentedString(this.oidc)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NameEnum {
        GENERIC(String.valueOf("generic")),
        AZURE_AD(String.valueOf("azureAd")),
        AUTH0(String.valueOf("auth0"));

        private String value;

        private NameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NameEnum fromValue(String value) {
            for (NameEnum b : NameEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

