/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ApplicationConfigKeystoreEntry;
import net.webpdf.wsclient.openapi.ApplicationConfigKeystoreFilter;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines settings for the global keystore used by the server. This keystore is used to store globally available certificates (e.g. for usage in the signature web service).")
@JsonPropertyOrder(value={"entry", "filter", "password", "type"})
@JsonTypeName(value="ApplicationConfig_Keystore")
public class ApplicationConfigKeystore {
    public static final String JSON_PROPERTY_ENTRY = "entry";
    private List<ApplicationConfigKeystoreEntry> entry = null;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private List<ApplicationConfigKeystoreFilter> filter = null;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password = "";
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.NONE;

    public ApplicationConfigKeystore entry(List<ApplicationConfigKeystoreEntry> entry) {
        this.entry = entry;
        return this;
    }

    public ApplicationConfigKeystore addEntryItem(ApplicationConfigKeystoreEntry entryItem) {
        if (this.entry == null) {
            this.entry = new ArrayList<ApplicationConfigKeystoreEntry>();
        }
        this.entry.add(entryItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="entry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<ApplicationConfigKeystoreEntry> getEntry() {
        return this.entry;
    }

    @JsonProperty(value="entry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntry(List<ApplicationConfigKeystoreEntry> entry) {
        this.entry = entry;
    }

    public ApplicationConfigKeystore filter(List<ApplicationConfigKeystoreFilter> filter) {
        this.filter = filter;
        return this;
    }

    public ApplicationConfigKeystore addFilterItem(ApplicationConfigKeystoreFilter filterItem) {
        if (this.filter == null) {
            this.filter = new ArrayList<ApplicationConfigKeystoreFilter>();
        }
        this.filter.add(filterItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<ApplicationConfigKeystoreFilter> getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(List<ApplicationConfigKeystoreFilter> filter) {
        this.filter = filter;
    }

    public ApplicationConfigKeystore password(String password) {
        this.password = password;
        return this;
    }

    @Schema(name="The password required to access the keystore.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public ApplicationConfigKeystore type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(name="The format of the keystore file.  *   NONE = Keystore not defined. *   JKS = A Java keystore (file based with an extension like \".jks\"). *   PKCS11 = A PKCS11 keystore (Smart cards, USB keys/token and hardware security modules (HSMs)). *   PKCS12 = A PKCS12 keystore (file based with the extensions like \".p12\" or \".pfx\").")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigKeystore applicationConfigKeystore = (ApplicationConfigKeystore)o;
        return Objects.equals(this.entry, applicationConfigKeystore.entry) && Objects.equals(this.filter, applicationConfigKeystore.filter) && Objects.equals(this.password, applicationConfigKeystore.password) && Objects.equals((Object)this.type, (Object)applicationConfigKeystore.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entry, this.filter, this.password, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigKeystore {\n");
        sb.append("    entry: ").append(this.toIndentedString(this.entry)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        NONE(String.valueOf("NONE")),
        JKS(String.valueOf("JKS")),
        PKCS11(String.valueOf("PKCS11")),
        PKCS12(String.valueOf("PKCS12")),
        WINDOWS_MACHINE(String.valueOf("WINDOWS_MACHINE")),
        WINDOWS_USER(String.valueOf("WINDOWS_USER"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

