/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The result of a used executable application.")
@JsonPropertyOrder(value={"applicationName", "commandLine", "consoleOutput", "exitCode", "isSuccessful", "message"})
@JsonTypeName(value="Admin_ExecutableResult")
public class AdminExecutableResult {
    public static final String JSON_PROPERTY_APPLICATION_NAME = "applicationName";
    private String applicationName = "";
    public static final String JSON_PROPERTY_COMMAND_LINE = "commandLine";
    private List<String> commandLine = null;
    public static final String JSON_PROPERTY_CONSOLE_OUTPUT = "consoleOutput";
    private List<String> consoleOutput = null;
    public static final String JSON_PROPERTY_EXIT_CODE = "exitCode";
    private Integer exitCode = 0;
    public static final String JSON_PROPERTY_IS_SUCCESSFUL = "isSuccessful";
    private Boolean isSuccessful = false;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message = "";

    public AdminExecutableResult applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    @Schema(name="The name of the executed application.")
    @JsonProperty(value="applicationName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    @JsonProperty(value="applicationName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public AdminExecutableResult commandLine(List<String> commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    public AdminExecutableResult addCommandLineItem(String commandLineItem) {
        if (this.commandLine == null) {
            this.commandLine = new ArrayList<String>();
        }
        this.commandLine.add(commandLineItem);
        return this;
    }

    @Schema(name="The commandline output created by the executed application.")
    @JsonProperty(value="commandLine")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<String> getCommandLine() {
        return this.commandLine;
    }

    @JsonProperty(value="commandLine")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommandLine(List<String> commandLine) {
        this.commandLine = commandLine;
    }

    public AdminExecutableResult consoleOutput(List<String> consoleOutput) {
        this.consoleOutput = consoleOutput;
        return this;
    }

    public AdminExecutableResult addConsoleOutputItem(String consoleOutputItem) {
        if (this.consoleOutput == null) {
            this.consoleOutput = new ArrayList<String>();
        }
        this.consoleOutput.add(consoleOutputItem);
        return this;
    }

    @Schema(name="The console output created by the executed application.")
    @JsonProperty(value="consoleOutput")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<String> getConsoleOutput() {
        return this.consoleOutput;
    }

    @JsonProperty(value="consoleOutput")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsoleOutput(List<String> consoleOutput) {
        this.consoleOutput = consoleOutput;
    }

    public AdminExecutableResult exitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    @Schema(name="The application specific exit code. This is not a webPDF error code and is defined by the called application itself.")
    @JsonProperty(value="exitCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getExitCode() {
        return this.exitCode;
    }

    @JsonProperty(value="exitCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public AdminExecutableResult isSuccessful(Boolean isSuccessful) {
        this.isSuccessful = isSuccessful;
        return this;
    }

    @Schema(name="When set to true, the execution has been successful.")
    @JsonProperty(value="isSuccessful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsSuccessful() {
        return this.isSuccessful;
    }

    @JsonProperty(value="isSuccessful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsSuccessful(Boolean isSuccessful) {
        this.isSuccessful = isSuccessful;
    }

    public AdminExecutableResult message(String message) {
        this.message = message;
        return this;
    }

    @Schema(name="A message summarizing the execution result.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminExecutableResult adminExecutableResult = (AdminExecutableResult)o;
        return Objects.equals(this.applicationName, adminExecutableResult.applicationName) && Objects.equals(this.commandLine, adminExecutableResult.commandLine) && Objects.equals(this.consoleOutput, adminExecutableResult.consoleOutput) && Objects.equals(this.exitCode, adminExecutableResult.exitCode) && Objects.equals(this.isSuccessful, adminExecutableResult.isSuccessful) && Objects.equals(this.message, adminExecutableResult.message);
    }

    public int hashCode() {
        return Objects.hash(this.applicationName, this.commandLine, this.consoleOutput, this.exitCode, this.isSuccessful, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminExecutableResult {\n");
        sb.append("    applicationName: ").append(this.toIndentedString(this.applicationName)).append("\n");
        sb.append("    commandLine: ").append(this.toIndentedString(this.commandLine)).append("\n");
        sb.append("    consoleOutput: ").append(this.toIndentedString(this.consoleOutput)).append("\n");
        sb.append("    exitCode: ").append(this.toIndentedString(this.exitCode)).append("\n");
        sb.append("    isSuccessful: ").append(this.toIndentedString(this.isSuccessful)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

