
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import net.webpdf.wsclient.schema.FileDataType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This element defines a file necessary for the transformation, which is passed "Base64 encoded". This element can be used with &lt;code&gt;&amp;lt;resources&amp;gt;&lt;/code&gt; or &lt;code&gt;&amp;lt;visualization&amp;gt;&lt;/code&gt;.&#13;
 *                     In the case of &lt;code&gt;&amp;lt;resources&amp;gt;&lt;/code&gt;, this is a file that defines, for example, an XLST stylesheet or a CSS resource. In the case of an X invoice and the parent &lt;code&gt;&amp;lt;visualization&amp;gt;&lt;/code&gt; it defines a file (XLST stylesheet) which defines a different layout for the PDF output.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for XslTransformationFileType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="XslTransformationFileType">
 *   <simpleContent>
 *     <extension base="<http://www.w3.org/2001/XMLSchema>base64Binary">
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}FileDataGroup"/>
 *       <attribute name="fileName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="format" default="xslt">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}XslTransformationFileFormatType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "XslTransformationFileType", propOrder = {
    "value"
})
public class XslTransformationFileType
    implements FileDataType<byte[]>
{

    @XmlValue
    protected byte[] value;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The filename of the file. This is the name under which the resource can be found again and is especially important for resources that are referenced from other files passed here via this name. (For example, the name of a CSS stylesheet that is referenced by name from an XSLT stylesheet).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fileName")
    protected String fileName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The type of the resource passed&#13;
     *                                 &lt;ul&gt;&lt;li&gt;xlst = An XSLT stylesheet to be used for the transformation.&lt;/li&gt;&lt;li&gt;other = Any other resource that is needed for the transformation. For example, this can be a CSS stylesheet, which is used by an output file of a transformation if it results in HTML output.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 The order of the resources can be important if multiple transformations are to be performed, i.e. multiple resources of the format "xlst" are passed. The transformations are performed in the order in which they are passed, in which case each transformation uses the output of the previous transformation as the starting point for its own transformation.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "format")
    protected XslTransformationFileFormatType format;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the data source for the hereby expressed resource.&#13;
     *                         Possible values are:&#13;
     *                         &lt;ul&gt;&lt;li&gt;value = The element's value shall contain the BASE64 encoded data.&lt;/li&gt;&lt;li&gt;uri = The data shall be located at the given uri.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "source")
    protected FileDataSourceType source;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The uri the data shall be located at. (This shall only have effect, if the "source" is "uri".)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "uri")
    @XmlSchemaType(name = "anyURI")
    protected String uri;

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setValue(byte[] value) {
        this.value = value;
    }

    public boolean isSetValue() {
        return (this.value!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The filename of the file. This is the name under which the resource can be found again and is especially important for resources that are referenced from other files passed here via this name. (For example, the name of a CSS stylesheet that is referenced by name from an XSLT stylesheet).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFileName() {
        if (fileName == null) {
            return "";
        } else {
            return fileName;
        }
    }

    /**
     * Sets the value of the fileName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFileName()
     */
    public void setFileName(String value) {
        this.fileName = value;
    }

    public boolean isSetFileName() {
        return (this.fileName!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The type of the resource passed&#13;
     *                                 &lt;ul&gt;&lt;li&gt;xlst = An XSLT stylesheet to be used for the transformation.&lt;/li&gt;&lt;li&gt;other = Any other resource that is needed for the transformation. For example, this can be a CSS stylesheet, which is used by an output file of a transformation if it results in HTML output.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 The order of the resources can be important if multiple transformations are to be performed, i.e. multiple resources of the format "xlst" are passed. The transformations are performed in the order in which they are passed, in which case each transformation uses the output of the previous transformation as the starting point for its own transformation.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link XslTransformationFileFormatType }
     *     
     */
    public XslTransformationFileFormatType getFormat() {
        if (format == null) {
            return XslTransformationFileFormatType.XSLT;
        } else {
            return format;
        }
    }

    /**
     * Sets the value of the format property.
     * 
     * @param value
     *     allowed object is
     *     {@link XslTransformationFileFormatType }
     *     
     * @see #getFormat()
     */
    public void setFormat(XslTransformationFileFormatType value) {
        this.format = value;
    }

    public boolean isSetFormat() {
        return (this.format!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the data source for the hereby expressed resource.&#13;
     *                         Possible values are:&#13;
     *                         &lt;ul&gt;&lt;li&gt;value = The element's value shall contain the BASE64 encoded data.&lt;/li&gt;&lt;li&gt;uri = The data shall be located at the given uri.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FileDataSourceType }
     *     
     */
    public FileDataSourceType getSource() {
        if (source == null) {
            return FileDataSourceType.VALUE;
        } else {
            return source;
        }
    }

    /**
     * Sets the value of the source property.
     * 
     * @param value
     *     allowed object is
     *     {@link FileDataSourceType }
     *     
     * @see #getSource()
     */
    public void setSource(FileDataSourceType value) {
        this.source = value;
    }

    public boolean isSetSource() {
        return (this.source!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The uri the data shall be located at. (This shall only have effect, if the "source" is "uri".)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUri() {
        if (uri == null) {
            return "";
        } else {
            return uri;
        }
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUri()
     */
    public void setUri(String value) {
        this.uri = value;
    }

    public boolean isSetUri() {
        return (this.uri!= null);
    }

}
