
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The watermark operation element can be used to add watermarks to the PDF document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for WatermarkType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="WatermarkType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <choice>
 *         <element name="text" type="{http://schema.webpdf.de/1.0/operation}WatermarkTextType" minOccurs="0"/>
 *         <element name="image" type="{http://schema.webpdf.de/1.0/operation}WatermarkImageType" minOccurs="0"/>
 *       </choice>
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="angle" default="45">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="360"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "WatermarkType", propOrder = {
    "text",
    "image"
})
public class WatermarkType
    extends BaseToolboxType
{

    protected WatermarkTextType text;
    protected WatermarkImageType image;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies on which page(s) the watermark should be created. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). A blank value or "*" selects all pages of the PDF document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the rotation angle for the text or image output of the watermark. Values between 0 and 360 are allowed. Rotation is performed clockwise.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "angle")
    protected Integer angle;

    /**
     * Gets the value of the text property.
     * 
     * @return
     *     possible object is
     *     {@link WatermarkTextType }
     *     
     */
    public WatermarkTextType getText() {
        return text;
    }

    /**
     * Sets the value of the text property.
     * 
     * @param value
     *     allowed object is
     *     {@link WatermarkTextType }
     *     
     */
    public void setText(WatermarkTextType value) {
        this.text = value;
    }

    public boolean isSetText() {
        return (this.text!= null);
    }

    /**
     * Gets the value of the image property.
     * 
     * @return
     *     possible object is
     *     {@link WatermarkImageType }
     *     
     */
    public WatermarkImageType getImage() {
        return image;
    }

    /**
     * Sets the value of the image property.
     * 
     * @param value
     *     allowed object is
     *     {@link WatermarkImageType }
     *     
     */
    public void setImage(WatermarkImageType value) {
        this.image = value;
    }

    public boolean isSetImage() {
        return (this.image!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies on which page(s) the watermark should be created. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). A blank value or "*" selects all pages of the PDF document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the rotation angle for the text or image output of the watermark. Values between 0 and 360 are allowed. Rotation is performed clockwise.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getAngle() {
        if (angle == null) {
            return  45;
        } else {
            return angle;
        }
    }

    /**
     * Sets the value of the angle property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getAngle()
     */
    public void setAngle(int value) {
        this.angle = value;
    }

    public boolean isSetAngle() {
        return (this.angle!= null);
    }

    public void unsetAngle() {
        this.angle = null;
    }

}
