
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the position of the watermark in the PDF document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for WatermarkPositionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="WatermarkPositionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="x" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="y" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="width" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="height" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="position" type="{http://schema.webpdf.de/1.0/operation}WatermarkPositionModeType" default="center_center" />
 *       <attribute name="aspectRatio" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="metrics" type="{http://schema.webpdf.de/1.0/operation}MetricsType" default="mm" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "WatermarkPositionType")
public class WatermarkPositionType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the X-axis position (as per metrics), starting from the top left corner of the PDF document, if position is set to "custom.". If "position is set to a different value, these arguments will be interpreted as "offsets" from the selected position. This specification applies for both the text and image output.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "x")
    protected Integer x;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the Y-axis position (as per metrics), starting from the top left corner of the PDF document, if position is set to "custom.". If "position is set to a different value, these arguments will be interpreted as "offsets" from the selected position. This specification applies for both the text and image output.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "y")
    protected Integer y;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Forces the specified width for the watermark if the values are not equal 0. In this case, the watermark will be scaled inside the area, which may result in the image losing quality or being distorted (please refer to "aspectRatio" as well)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "width")
    protected Integer width;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Forces the specified height for the watermark if the values are not equal 0. In this case, the watermark will be scaled inside the area, which may result in the image losing quality or being distorted (please refer to "aspectRatio" as well)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "height")
    protected Integer height;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Uses one of multiple preset positions in order to position the watermark on the page.&#13;
     *                         &lt;ul&gt;&lt;li&gt;custom = Disable the use of a preset position.&lt;/li&gt;&lt;li&gt;top_left = Positions the watermark in the top left corner.&lt;/li&gt;&lt;li&gt;top_center = Positions the watermark in the centre at the top margin.&lt;/li&gt;&lt;li&gt;top_right = Positions the watermark in the top right corner.&lt;/li&gt;&lt;li&gt;center_left = Positions the watermark at the centre of the page, to the left.&lt;/li&gt;&lt;li&gt;center_center = Positions the watermark at the centre of the page.&lt;/li&gt;&lt;li&gt;center_right = Positions the watermark at the centre of the page, to the right.&lt;/li&gt;&lt;li&gt;bottom_left = Positions the watermark in the bottom left corner.&lt;/li&gt;&lt;li&gt;bottom_center = Positions the watermark in the centre at the bottom margin.&lt;/li&gt;&lt;li&gt;bottom_right = Positions the watermark in the bottom right corner.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "position")
    protected WatermarkPositionModeType position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Forces the aspect ratio to be maintained when a watermark is scaled if "width" and "height" are specified.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "aspectRatio")
    protected Boolean aspectRatio;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the unit in which the maximum dimensions are specified.&#13;
     *                         &lt;ul&gt;&lt;li&gt;pt = Points(1/72 inch)&lt;/li&gt;&lt;li&gt;pc = Picas(12 points)&lt;/li&gt;&lt;li&gt;px = Pixels(1/96 inch)&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "metrics")
    protected MetricsType metrics;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the X-axis position (as per metrics), starting from the top left corner of the PDF document, if position is set to "custom.". If "position is set to a different value, these arguments will be interpreted as "offsets" from the selected position. This specification applies for both the text and image output.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getX() {
        if (x == null) {
            return  0;
        } else {
            return x;
        }
    }

    /**
     * Sets the value of the x property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getX()
     */
    public void setX(int value) {
        this.x = value;
    }

    public boolean isSetX() {
        return (this.x!= null);
    }

    public void unsetX() {
        this.x = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the Y-axis position (as per metrics), starting from the top left corner of the PDF document, if position is set to "custom.". If "position is set to a different value, these arguments will be interpreted as "offsets" from the selected position. This specification applies for both the text and image output.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getY() {
        if (y == null) {
            return  0;
        } else {
            return y;
        }
    }

    /**
     * Sets the value of the y property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getY()
     */
    public void setY(int value) {
        this.y = value;
    }

    public boolean isSetY() {
        return (this.y!= null);
    }

    public void unsetY() {
        this.y = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Forces the specified width for the watermark if the values are not equal 0. In this case, the watermark will be scaled inside the area, which may result in the image losing quality or being distorted (please refer to "aspectRatio" as well)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getWidth() {
        if (width == null) {
            return  0;
        } else {
            return width;
        }
    }

    /**
     * Sets the value of the width property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getWidth()
     */
    public void setWidth(int value) {
        this.width = value;
    }

    public boolean isSetWidth() {
        return (this.width!= null);
    }

    public void unsetWidth() {
        this.width = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Forces the specified height for the watermark if the values are not equal 0. In this case, the watermark will be scaled inside the area, which may result in the image losing quality or being distorted (please refer to "aspectRatio" as well)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getHeight() {
        if (height == null) {
            return  0;
        } else {
            return height;
        }
    }

    /**
     * Sets the value of the height property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getHeight()
     */
    public void setHeight(int value) {
        this.height = value;
    }

    public boolean isSetHeight() {
        return (this.height!= null);
    }

    public void unsetHeight() {
        this.height = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Uses one of multiple preset positions in order to position the watermark on the page.&#13;
     *                         &lt;ul&gt;&lt;li&gt;custom = Disable the use of a preset position.&lt;/li&gt;&lt;li&gt;top_left = Positions the watermark in the top left corner.&lt;/li&gt;&lt;li&gt;top_center = Positions the watermark in the centre at the top margin.&lt;/li&gt;&lt;li&gt;top_right = Positions the watermark in the top right corner.&lt;/li&gt;&lt;li&gt;center_left = Positions the watermark at the centre of the page, to the left.&lt;/li&gt;&lt;li&gt;center_center = Positions the watermark at the centre of the page.&lt;/li&gt;&lt;li&gt;center_right = Positions the watermark at the centre of the page, to the right.&lt;/li&gt;&lt;li&gt;bottom_left = Positions the watermark in the bottom left corner.&lt;/li&gt;&lt;li&gt;bottom_center = Positions the watermark in the centre at the bottom margin.&lt;/li&gt;&lt;li&gt;bottom_right = Positions the watermark in the bottom right corner.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link WatermarkPositionModeType }
     *     
     */
    public WatermarkPositionModeType getPosition() {
        if (position == null) {
            return WatermarkPositionModeType.CENTER_CENTER;
        } else {
            return position;
        }
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link WatermarkPositionModeType }
     *     
     * @see #getPosition()
     */
    public void setPosition(WatermarkPositionModeType value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Forces the aspect ratio to be maintained when a watermark is scaled if "width" and "height" are specified.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isAspectRatio() {
        if (aspectRatio == null) {
            return true;
        } else {
            return aspectRatio;
        }
    }

    /**
     * Sets the value of the aspectRatio property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isAspectRatio()
     */
    public void setAspectRatio(boolean value) {
        this.aspectRatio = value;
    }

    public boolean isSetAspectRatio() {
        return (this.aspectRatio!= null);
    }

    public void unsetAspectRatio() {
        this.aspectRatio = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the unit in which the maximum dimensions are specified.&#13;
     *                         &lt;ul&gt;&lt;li&gt;pt = Points(1/72 inch)&lt;/li&gt;&lt;li&gt;pc = Picas(12 points)&lt;/li&gt;&lt;li&gt;px = Pixels(1/96 inch)&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MetricsType }
     *     
     */
    public MetricsType getMetrics() {
        if (metrics == null) {
            return MetricsType.MM;
        } else {
            return metrics;
        }
    }

    /**
     * Sets the value of the metrics property.
     * 
     * @param value
     *     allowed object is
     *     {@link MetricsType }
     *     
     * @see #getMetrics()
     */
    public void setMetrics(MetricsType value) {
        this.metrics = value;
    }

    public boolean isSetMetrics() {
        return (this.metrics!= null);
    }

}
